/**
 * Copyright (C) 2006  Robin Bygrave
 * 
 * This file is part of Ebean.
 * 
 * Ebean is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *  
 * Ebean is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Ebean; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  
 */
package com.avaje.ebean.config.dbplatform;

import java.sql.Types;

import javax.sql.DataSource;

import com.avaje.ebean.BackgroundExecutor;

/**
 * DB2 specific platform.
 */
public class DB2Platform extends DatabasePlatform {

    public DB2Platform(){
        super();
        this.name = "db2";
        
        // only support getGeneratedKeys with non-batch JDBC 
        // so generally use SEQUENCE instead for H2
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setIdType(IdType.IDENTITY);        
        this.dbIdentity.setSupportsSequence(true);

        this.openQuote = "\"";
        this.closeQuote = "\"";
        

        booleanDbType = Types.INTEGER;
        dbTypeMap.put(Types.BOOLEAN, new DbType("smallint default 0"));
        dbTypeMap.put(Types.INTEGER, new DbType("integer"));
        dbTypeMap.put(Types.BIGINT, new DbType("bigint"));
        dbTypeMap.put(Types.REAL, new DbType("float"));
        dbTypeMap.put(Types.DOUBLE, new DbType("float"));
        dbTypeMap.put(Types.SMALLINT, new DbType("smallint"));
        dbTypeMap.put(Types.TINYINT, new DbType("smallint"));
        dbTypeMap.put(Types.DECIMAL, new DbType("decimal", 15));
  
        this.dbDdlSyntax.setIdentity("generated by default as identity");
        
        //this.dbDdlSyntax.setDropIfExists("if exists");
        //this.dbDdlSyntax.setDisableReferentialIntegrity("SET REFERENTIAL_INTEGRITY FALSE");
        //this.dbDdlSyntax.setEnableReferentialIntegrity("SET REFERENTIAL_INTEGRITY TRUE");
        //this.dbDdlSyntax.setForeignKeySuffix("on delete restrict on update restrict");
    }

    /**
     * Return a DB2 specific sequence IdGenerator that supports batch fetching
     * sequence values.
     */
	@Override
	public IdGenerator createSequenceIdGenerator(BackgroundExecutor be,
			DataSource ds, String seqName, int batchSize) {
		
		return new DB2SequenceIdGenerator(be, ds, seqName, batchSize);
	}    
    
}
