/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.xml.PrettyPrintXMLWriter;

public class XmlSummaryFileTarget
implements ExecutionTarget {
    public static final int XML_INDENTATION_SIZE = 2;
    protected final String encoding;
    protected Map<ChecksumFile, Map<String, String>> filesHashcodes;
    protected final File summaryFile;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public XmlSummaryFileTarget(File summaryFile, String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
        this.artifactListeners = artifactListeners;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<ChecksumFile, Map<String, String>>();
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
    }

    @Override
    public void close(final String subPath) throws ExecutionTargetCloseException {
        OutputStreamWriter outputStream;
        try {
            Files.createDirectories(this.summaryFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException("Could not create summary file parent directory", e);
        }
        try {
            outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.summaryFile), this.encoding);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new ExecutionTargetCloseException("Failed writing to output summary file", e);
        }
        Map.Entry[] entries = this.filesHashcodes.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entries, new Comparator<Map.Entry<ChecksumFile, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<ChecksumFile, Map<String, String>> o1, Map.Entry<ChecksumFile, Map<String, String>> o2) {
                ChecksumFile f1 = o1.getKey();
                ChecksumFile f2 = o2.getKey();
                return f1.getRelativePath(f1, subPath).compareTo(f2.getRelativePath(f2, subPath));
            }
        });
        try {
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)outputStream, StringUtils.repeat((String)" ", (int)2));
            xmlWriter.startElement("files");
            for (Map.Entry entry : entries) {
                ChecksumFile file = (ChecksumFile)entry.getKey();
                xmlWriter.startElement("file");
                xmlWriter.addAttribute("name", file.getRelativePath(file, subPath));
                Map fileHashcodes = (Map)entry.getValue();
                for (String algorithm : fileHashcodes.keySet()) {
                    xmlWriter.startElement("hashcode");
                    xmlWriter.addAttribute("algorithm", algorithm);
                    xmlWriter.writeText((String)fileHashcodes.get(algorithm));
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException("Failed writing to output summary file", e);
        }
        try {
            ((Writer)outputStream).close();
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(this.summaryFile, "xml", null, null);
            }
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException("Failed writing to output summary file", e);
        }
    }
}

