/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;

public class CsvSummaryFileTarget
implements ExecutionTarget {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CSV_COLUMN_SEPARATOR = ",";
    public static final String CSV_COMMENT_MARKER = "#";
    protected final String encoding;
    protected Map<ChecksumFile, Map<String, String>> filesHashcodes;
    protected SortedSet<String> algorithms;
    protected final File summaryFile;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public CsvSummaryFileTarget(File summaryFile, String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
        this.artifactListeners = artifactListeners;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<ChecksumFile, Map<String, String>>();
        this.algorithms = new TreeSet<String>();
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
        this.algorithms.add(algorithm);
    }

    @Override
    public void close(final String subPath) throws ExecutionTargetCloseException {
        try {
            Files.createDirectories(this.summaryFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException("Could not create summary file parent directory", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CSV_COMMENT_MARKER).append("File");
        for (String string : this.algorithms) {
            sb.append(CSV_COLUMN_SEPARATOR).append(string);
        }
        Map.Entry[] entries = this.filesHashcodes.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entries, new Comparator<Map.Entry<ChecksumFile, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<ChecksumFile, Map<String, String>> o1, Map.Entry<ChecksumFile, Map<String, String>> o2) {
                ChecksumFile f1 = o1.getKey();
                ChecksumFile f2 = o2.getKey();
                return f1.getRelativePath(f1, subPath).compareTo(f2.getRelativePath(f2, subPath));
            }
        });
        for (Map.Entry entry : entries) {
            ChecksumFile file = (ChecksumFile)entry.getKey();
            sb.append(LINE_SEPARATOR).append(file.getRelativePath(file, subPath));
            Map fileHashcodes = (Map)entry.getValue();
            for (String algorithm : this.algorithms) {
                sb.append(CSV_COLUMN_SEPARATOR);
                if (!fileHashcodes.containsKey(algorithm)) continue;
                sb.append((String)fileHashcodes.get(algorithm));
            }
        }
        sb.append(LINE_SEPARATOR);
        try {
            Files.write(this.summaryFile.toPath(), sb.toString().getBytes(this.encoding), StandardOpenOption.CREATE);
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(this.summaryFile, "csv", null, null);
            }
        }
        catch (IOException iOException) {
            throw new ExecutionTargetCloseException("Failed writing to output summary file", iOException);
        }
    }
}

