/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.query.dataorder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.luckperms.api.model.data.DataType;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum DataQueryOrder implements Comparator<DataType>
{
    TRANSIENT_FIRST{

        @Override
        public int compare(DataType o1, DataType o2) {
            if (o1 == o2) {
                return 0;
            }
            return Boolean.compare(o1 == DataType.TRANSIENT, o2 == DataType.TRANSIENT);
        }
    }
    ,
    TRANSIENT_LAST{

        @Override
        public int compare(DataType o1, DataType o2) {
            if (o1 == o2) {
                return 0;
            }
            return -Boolean.compare(o1 == DataType.TRANSIENT, o2 == DataType.TRANSIENT);
        }
    };

    private static final List<DataType> TRANSIENT_FIRST_LIST;
    private static final List<DataType> TRANSIENT_LAST_LIST;

    public static List<DataType> order(@NonNull Comparator<? super DataType> comparator) {
        int compare = comparator.compare(DataType.TRANSIENT, DataType.NORMAL);
        if (compare > 0) {
            return TRANSIENT_FIRST_LIST;
        }
        if (compare < 0) {
            return TRANSIENT_LAST_LIST;
        }
        throw new IllegalStateException("Comparator " + comparator + " does not define an order between DataType.NORMAL and DataType.TRANSIENT!");
    }

    public static void queryInOrder(@NonNull Comparator<? super DataType> comparator, @NonNull Consumer<? super DataType> action) {
        DataQueryOrder.order(comparator).forEach(action);
    }

    static {
        TRANSIENT_FIRST_LIST = Collections.unmodifiableList(Arrays.asList(DataType.TRANSIENT, DataType.NORMAL));
        TRANSIENT_LAST_LIST = Collections.unmodifiableList(Arrays.asList(DataType.NORMAL, DataType.TRANSIENT));
    }
}

