/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.query;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.OptionKey;
import net.luckperms.api.query.QueryMode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface QueryOptions {
    public static @NonNull Builder builder(@NonNull QueryMode mode) {
        return LuckPermsProvider.get().getContextManager().queryOptionsBuilder(mode);
    }

    public static @NonNull QueryOptions contextual(@NonNull ContextSet context, @NonNull Set<Flag> flags) {
        return QueryOptions.builder(QueryMode.CONTEXTUAL).context(context).flags(flags).build();
    }

    public static @NonNull QueryOptions contextual(@NonNull ContextSet context) {
        return QueryOptions.builder(QueryMode.CONTEXTUAL).context(context).build();
    }

    public static @NonNull QueryOptions nonContextual(@NonNull Set<Flag> flags) {
        return QueryOptions.builder(QueryMode.NON_CONTEXTUAL).flags(flags).build();
    }

    public static @NonNull QueryOptions nonContextual() {
        return LuckPermsProvider.get().getQueryOptionsRegistry().defaultNonContextualOptions();
    }

    public static @NonNull QueryOptions defaultContextualOptions() {
        return LuckPermsProvider.get().getQueryOptionsRegistry().defaultContextualOptions();
    }

    public @NonNull QueryMode mode();

    public @NonNull ImmutableContextSet context();

    public boolean flag(@NonNull Flag var1);

    public @NonNull Set<Flag> flags();

    public <O> @NonNull Optional<O> option(@NonNull OptionKey<O> var1);

    public @NonNull Map<OptionKey<?>, Object> options();

    public boolean satisfies(@NonNull ContextSet var1);

    public @NonNull Builder toBuilder();

    public static interface Builder {
        public @NonNull Builder mode(@NonNull QueryMode var1);

        public @NonNull Builder context(@NonNull ContextSet var1);

        public @NonNull Builder flag(@NonNull Flag var1, boolean var2);

        public @NonNull Builder flags(@NonNull Set<Flag> var1);

        public <O> @NonNull Builder option(@NonNull OptionKey<O> var1, @Nullable O var2);

        public @NonNull QueryOptions build();
    }
}

