/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.text.BuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.ComponentBuilder;
import net.kyori.text.ScopedComponent;
import net.kyori.text.TranslatableComponentImpl;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TranslatableComponent
extends BuildableComponent<TranslatableComponent, Builder>,
ScopedComponent<TranslatableComponent> {
    public static @NonNull Builder builder() {
        return new TranslatableComponentImpl.BuilderImpl();
    }

    public static @NonNull Builder builder(@NonNull String key) {
        return TranslatableComponent.builder().key(key);
    }

    public static @NonNull TranslatableComponent of(@NonNull String key) {
        return (TranslatableComponent)TranslatableComponent.builder(key).build();
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color) {
        return (TranslatableComponent)((Builder)TranslatableComponent.builder(key).color(color)).build();
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color, TextDecoration ... decorations) {
        HashSet<TextDecoration> activeDecorations = new HashSet<TextDecoration>(decorations.length);
        Collections.addAll(activeDecorations, decorations);
        return TranslatableComponent.of(key, color, activeDecorations);
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return (TranslatableComponent)((Builder)((Builder)TranslatableComponent.builder(key).color(color)).decorations(decorations, true)).build();
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, Component ... args) {
        return TranslatableComponent.of(key, null, args);
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color, Component ... args) {
        return TranslatableComponent.of(key, color, Collections.emptySet(), args);
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, Component ... args) {
        return TranslatableComponent.of(key, color, decorations, Arrays.asList(args));
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @NonNull List<? extends Component> args) {
        return TranslatableComponent.of(key, null, args);
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull List<? extends Component> args) {
        return TranslatableComponent.of(key, color, Collections.emptySet(), args);
    }

    public static @NonNull TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, @NonNull List<? extends Component> args) {
        return (TranslatableComponent)((Builder)((Builder)TranslatableComponent.builder(key).color(color)).decorations(decorations, true)).args(args).build();
    }

    public static @NonNull TranslatableComponent make(@NonNull Consumer<? super Builder> consumer) {
        Builder builder = TranslatableComponent.builder();
        consumer.accept(builder);
        return (TranslatableComponent)builder.build();
    }

    public static @NonNull TranslatableComponent make(@NonNull String key, @NonNull Consumer<? super Builder> consumer) {
        Builder builder = TranslatableComponent.builder(key);
        consumer.accept(builder);
        return (TranslatableComponent)builder.build();
    }

    public static @NonNull TranslatableComponent make(@NonNull String key, @NonNull List<? extends Component> args, @NonNull Consumer<? super Builder> consumer) {
        Builder builder = TranslatableComponent.builder(key).args(args);
        consumer.accept(builder);
        return (TranslatableComponent)builder.build();
    }

    public @NonNull String key();

    public @NonNull TranslatableComponent key(@NonNull String var1);

    public @NonNull List<Component> args();

    public @NonNull TranslatableComponent args(@NonNull List<? extends Component> var1);

    public static interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder> {
        public @NonNull Builder key(@NonNull String var1);

        public @NonNull Builder args(ComponentBuilder<?, ?> ... var1);

        public @NonNull Builder args(Component ... var1);

        public @NonNull Builder args(@NonNull List<? extends Component> var1);
    }
}

