/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public interface Buildable<R, B extends Builder<R>> {
    @Contract(mutates="param1")
    public static <R extends Buildable<R, B>, B extends Builder<R>> @NonNull R configureAndBuild(@NonNull B builder, @Nullable Consumer<? super B> consumer) {
        if (consumer != null) {
            consumer.accept(builder);
        }
        return (R)((Buildable)builder.build());
    }

    @Contract(value="-> new", pure=true)
    public @NonNull B toBuilder();

    public static interface Builder<R> {
        @Contract(value="-> new", pure=true)
        public @NonNull R build();
    }
}

