/*
 * Copyright (C) 2005-2015 Schlichtherle IT Services.
 * All rights reserved. Use is subject to license terms.
 */
package net.java.truevfs.kernel.impl

import net.java.truecommons.cio.Entry._
import net.java.truecommons.cio._
import net.java.truecommons.shed._
import net.java.truevfs.kernel.spec._

import scala.Option

/** Provides read/write access to an archive file system.
  * This is a mirror of [[net.java.truevfs.kernel.spec.FsController]] which has
  * been customized to leverage the Scala language and library.
  *
  * @author Christian Schlichtherle
  */
private trait ArchiveController[E <: FsArchiveEntry] {

  /** Returns the archive model.
    *
    * @return The archive model.
    */
  def model: ArchiveModel[E]

  def node(options: AccessOptions, name: FsNodeName): Option[FsNode]
  def checkAccess(options: AccessOptions, name: FsNodeName, types: BitField[Access]): Unit
  def setReadOnly(options: AccessOptions, name: FsNodeName): Unit
  def setTime(options: AccessOptions, name: FsNodeName, times: Map[Access, Long]): Boolean
  def setTime(options: AccessOptions, name: FsNodeName, types: BitField[Access], value: Long): Boolean
  def input(options: AccessOptions, name: FsNodeName): AnyInputSocket
  def output(options: AccessOptions, name: FsNodeName, template: Option[Entry]): AnyOutputSocket
  def make(options: AccessOptions, name: FsNodeName, tµpe: Type, template: Option[Entry]): Unit
  def unlink(options: AccessOptions, name: FsNodeName): Unit
  def sync(options: SyncOptions): Unit

  /** Two archive controllers are considered equal if and only if they are
    * identical.
    *
    * @param  that the object to compare.
    * @return `this == that`
    */
  final override def equals(that: Any): Boolean = this == that

  /** Returns a hash code which is consistent with `equals`.
    *
    * @return A hash code which is consistent with `equals`.
    * @see    Object#hashCode
    */
   final override def hashCode: Int = System.identityHashCode(this)

  /** Returns a string representation of this object for logging and debugging
    * purposes.
    */
  final override def toString: String = "%s@%x[model=%s]".format(getClass.getName, hashCode, model)
}
