/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Source;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.comp.zipdriver.JarDriver;
import net.java.truevfs.comp.zipdriver.JarDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.driver.zip.raes.KeyManagerRaesParameters;
import net.java.truevfs.driver.zip.raes.ZipRaesKeyController;
import net.java.truevfs.driver.zip.raes.crypto.RaesOutputStream;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesReadOnlyChannel;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;

@Immutable
public abstract class ZipRaesDriver
extends JarDriver {
    public final boolean getPreambled() {
        return true;
    }

    protected RaesParameters raesParameters(FsModel model) {
        return new KeyManagerRaesParameters(this.getKeyManagerMap(), this.mountPointUri(model));
    }

    protected abstract long getAuthenticationTrigger();

    public final boolean check(JarDriverEntry local, ZipInputService<JarDriverEntry> input) {
        return input.length() > this.getAuthenticationTrigger();
    }

    public FsController decorate(FsController controller) {
        return new ZipRaesKeyController(controller, this);
    }

    protected ZipInputService<JarDriverEntry> newZipInput(final FsModel model, final FsInputSocketSource source) throws IOException {
        final class Source
        extends FsInputSocketSource {
            Source() {
                super(fsInputSocketSource);
            }

            public SeekableByteChannel channel() throws IOException {
                RaesReadOnlyChannel channel = RaesReadOnlyChannel.create(ZipRaesDriver.this.raesParameters(model), (net.java.truecommons.io.Source)source);
                try {
                    if (channel.size() <= ZipRaesDriver.this.getAuthenticationTrigger()) {
                        channel.authenticate();
                    }
                    return channel;
                }
                catch (Throwable ex) {
                    try {
                        channel.close();
                    }
                    catch (IOException ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new ZipInputService(model, (FsInputSocketSource)new Source(), (AbstractZipDriver)this);
    }

    protected OutputService<JarDriverEntry> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<JarDriverEntry> input) throws IOException {
        ZipInputService zis = (ZipInputService)input;
        return new MultiplexingOutputService(this.getPool(), (OutputService)new ZipOutputService(model, (FsOutputSocketSink)new RaesSocketSink(model, sink), zis, (AbstractZipDriver)this));
    }

    protected final FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller, FsNodeName name) {
        options = options.set((Enum)FsAccessOption.STORE);
        options = options.clear((Enum)FsAccessOption.GROW);
        return new FsOutputSocketSink(options, controller.output(options, name, null));
    }

    public JarDriverEntry newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        JarDriverEntry entry = (JarDriverEntry)super.newEntry(options.set((Enum)FsAccessOption.COMPRESS), name, type, template);
        entry.clearEncryption();
        return entry;
    }

    final class RaesSocketSink
    extends FsOutputSocketSink {
        private final FsModel model;
        private final FsOutputSocketSink sink;

        RaesSocketSink(FsModel model, FsOutputSocketSink sink) {
            super(sink);
            this.model = model;
            this.sink = sink;
        }

        public OutputStream stream() throws IOException {
            return RaesOutputStream.create(ZipRaesDriver.this.raesParameters(this.model), (Sink)this.sink);
        }

        public SeekableByteChannel channel() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

