/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.collections;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ExpireHashMap<K, V> {
    private final Map<K, ExpireEntry> keyLookup = new HashMap<K, ExpireEntry>();
    private final PriorityQueue<ExpireEntry> expireQueue = new PriorityQueue();
    private final Map<K, V> valueView = Maps.transformValues(this.keyLookup, entry -> entry.expireValue);
    private final Ticker ticker;

    public ExpireHashMap() {
        this(Ticker.systemTicker());
    }

    public ExpireHashMap(Ticker ticker) {
        this.ticker = ticker;
    }

    public V get(K key) {
        this.evictExpired();
        ExpireEntry entry = this.keyLookup.get(key);
        return entry != null ? (V)entry.expireValue : null;
    }

    public V put(K key, V value, long expireDelay, TimeUnit expireUnit) {
        Preconditions.checkNotNull((Object)((Object)expireUnit), (Object)"expireUnit cannot be NULL");
        Preconditions.checkState((expireDelay > 0L ? 1 : 0) != 0, (Object)"expireDelay cannot be equal or less than zero.");
        this.evictExpired();
        ExpireEntry entry = new ExpireEntry(this.ticker.read() + TimeUnit.NANOSECONDS.convert(expireDelay, expireUnit), key, value);
        ExpireEntry previous = this.keyLookup.put(key, entry);
        this.expireQueue.add(entry);
        return previous != null ? (V)previous.expireValue : null;
    }

    public boolean containsKey(K key) {
        this.evictExpired();
        return this.keyLookup.containsKey(key);
    }

    public boolean containsValue(V value) {
        this.evictExpired();
        for (ExpireEntry entry : this.keyLookup.values()) {
            if (!Objects.equal(value, entry.expireValue)) continue;
            return true;
        }
        return false;
    }

    public V removeKey(K key) {
        this.evictExpired();
        ExpireEntry entry = this.keyLookup.remove(key);
        return entry != null ? (V)entry.expireValue : null;
    }

    public int size() {
        this.evictExpired();
        return this.keyLookup.size();
    }

    public Set<K> keySet() {
        this.evictExpired();
        return this.keyLookup.keySet();
    }

    public Collection<V> values() {
        this.evictExpired();
        return this.valueView.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.evictExpired();
        return this.valueView.entrySet();
    }

    public Map<K, V> asMap() {
        this.evictExpired();
        return this.valueView;
    }

    public void collect() {
        this.evictExpired();
        this.expireQueue.clear();
        this.expireQueue.addAll(this.keyLookup.values());
    }

    public void clear() {
        this.keyLookup.clear();
        this.expireQueue.clear();
    }

    protected void evictExpired() {
        long currentTime = this.ticker.read();
        while (this.expireQueue.size() > 0 && this.expireQueue.peek().expireTime <= currentTime) {
            ExpireEntry entry = this.expireQueue.poll();
            if (entry != this.keyLookup.get(entry.expireKey)) continue;
            this.keyLookup.remove(entry.expireKey);
        }
    }

    public String toString() {
        return this.valueView.toString();
    }

    private class ExpireEntry
    implements Comparable<ExpireEntry> {
        public final long expireTime;
        public final K expireKey;
        public final V expireValue;

        public ExpireEntry(long expireTime, K expireKey, V expireValue) {
            this.expireTime = expireTime;
            this.expireKey = expireKey;
            this.expireValue = expireValue;
        }

        @Override
        public int compareTo(ExpireEntry o) {
            return Longs.compare((long)this.expireTime, (long)o.expireTime);
        }

        public String toString() {
            return "ExpireEntry [expireTime=" + this.expireTime + ", expireKey=" + String.valueOf(this.expireKey) + ", expireValue=" + String.valueOf(this.expireValue) + "]";
        }
    }
}

