/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import me.lucko.luckperms.api.FullySatisfiedContexts;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

@Immutable
public class Contexts {
    public static final String SERVER_KEY = "server";
    public static final String WORLD_KEY = "world";
    private static final EnumSet<LookupSetting> DEFAULT_SETTINGS = EnumSet.of(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER, LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD, LookupSetting.RESOLVE_INHERITANCE, LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER, LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
    private static final Contexts GLOBAL = new Contexts(ImmutableContextSet.empty(), (ImmutableSet<LookupSetting>)ImmutableSet.copyOf(DEFAULT_SETTINGS));
    private final ImmutableContextSet contextSet;
    private final ImmutableSet<LookupSetting> settings;
    private final int hashCode;

    @Nonnull
    public static Contexts allowAll() {
        return FullySatisfiedContexts.getInstance();
    }

    @Nonnull
    public static Contexts global() {
        return GLOBAL;
    }

    @Nonnull
    public static Contexts of(@Nonnull ContextSet contextSet, boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        Objects.requireNonNull(contextSet, "contextSet");
        EnumSet<LookupSetting> settings = Contexts.formSettings(includeNodesSetWithoutServer, includeNodesSetWithoutWorld, resolveInheritance, applyParentsWithoutServer, applyParentsWithoutWorld, isOp);
        if (contextSet.isEmpty() && DEFAULT_SETTINGS.equals(settings)) {
            return GLOBAL;
        }
        return new Contexts(contextSet.makeImmutable(), (ImmutableSet<LookupSetting>)ImmutableSet.copyOf(settings));
    }

    public static Contexts of(@Nonnull ContextSet contextSet, @Nonnull Set<LookupSetting> settings) {
        Objects.requireNonNull(contextSet, "contextSet");
        Objects.requireNonNull(settings, "settings");
        EnumSet<LookupSetting> settingsCopy = EnumSet.copyOf(settings);
        if (contextSet.isEmpty() && DEFAULT_SETTINGS.equals(settingsCopy)) {
            return GLOBAL;
        }
        return new Contexts(contextSet.makeImmutable(), (ImmutableSet<LookupSetting>)ImmutableSet.copyOf(settingsCopy));
    }

    @Deprecated
    public Contexts(@Nonnull ContextSet contextSet, boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        this.contextSet = Objects.requireNonNull(contextSet, "contextSet").makeImmutable();
        this.settings = ImmutableSet.copyOf(Contexts.formSettings(includeNodesSetWithoutServer, includeNodesSetWithoutWorld, resolveInheritance, applyParentsWithoutServer, applyParentsWithoutWorld, isOp));
        this.hashCode = this.calculateHashCode();
    }

    protected Contexts(@Nonnull ImmutableContextSet contextSet, @Nonnull ImmutableSet<LookupSetting> settings) {
        this.contextSet = contextSet;
        this.settings = settings;
        this.hashCode = this.calculateHashCode();
    }

    @Nonnull
    public ContextSet getContexts() {
        return this.contextSet;
    }

    @Nonnull
    public Set<LookupSetting> getSettings() {
        return this.settings;
    }

    public boolean hasSetting(@Nonnull LookupSetting setting) {
        return this.settings.contains((Object)setting);
    }

    @Deprecated
    public boolean isOp() {
        return this.hasSetting(LookupSetting.IS_OP);
    }

    @Deprecated
    public boolean isIncludeGlobal() {
        return this.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER);
    }

    @Deprecated
    public boolean isIncludeGlobalWorld() {
        return this.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD);
    }

    @Deprecated
    public boolean isApplyGroups() {
        return this.hasSetting(LookupSetting.RESOLVE_INHERITANCE);
    }

    @Deprecated
    public boolean isApplyGlobalGroups() {
        return this.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER);
    }

    @Deprecated
    public boolean isApplyGlobalWorldGroups() {
        return this.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
    }

    @Nonnull
    public String toString() {
        return "Contexts(contextSet=" + this.contextSet + ", settings=" + this.settings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == Contexts.allowAll()) {
            return false;
        }
        if (!(o instanceof Contexts)) {
            return false;
        }
        Contexts that = (Contexts)o;
        return this.contextSet.equals(that.contextSet) && this.settings.equals(that.settings);
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.contextSet.hashCode();
        result = result * 59 + this.settings.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static EnumSet<LookupSetting> formSettings(boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        EnumSet<LookupSetting> settings = EnumSet.noneOf(LookupSetting.class);
        if (includeNodesSetWithoutServer) {
            settings.add(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER);
        }
        if (includeNodesSetWithoutWorld) {
            settings.add(LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD);
        }
        if (resolveInheritance) {
            settings.add(LookupSetting.RESOLVE_INHERITANCE);
        }
        if (applyParentsWithoutServer) {
            settings.add(LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER);
        }
        if (applyParentsWithoutWorld) {
            settings.add(LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
        }
        if (isOp) {
            settings.add(LookupSetting.IS_OP);
        }
        return settings;
    }
}

