/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public final class MutableContextSet
implements ContextSet {
    private final SetMultimap<String, String> map;

    @Nonnull
    public static MutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        MutableContextSet set = MutableContextSet.create();
        set.add(key, value);
        return set;
    }

    @Nonnull
    public static MutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        Preconditions.checkNotNull((Object)key1, (Object)"key1");
        Preconditions.checkNotNull((Object)value1, (Object)"value1");
        Preconditions.checkNotNull((Object)key2, (Object)"key2");
        Preconditions.checkNotNull((Object)value2, (Object)"value2");
        MutableContextSet set = MutableContextSet.create();
        set.add(key1, value1);
        set.add(key2, value2);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Preconditions.checkNotNull(iterable, (Object)"iterable");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(iterable);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMap(@Nonnull Map<String, String> map) {
        Preconditions.checkNotNull(map, (Object)"map");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(map);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        Preconditions.checkNotNull(multimap, (Object)"multimap");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(multimap);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        Preconditions.checkNotNull((Object)contextSet, (Object)"contextSet");
        MutableContextSet set = new MutableContextSet();
        set.addAll(contextSet.toSet());
        return set;
    }

    @Nonnull
    public static MutableContextSet create() {
        return new MutableContextSet();
    }

    public MutableContextSet() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    private MutableContextSet(MutableContextSet other) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(other.map));
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    @Nonnull
    public ImmutableContextSet makeImmutable() {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf(this.map));
    }

    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        return new MutableContextSet(this);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    @Nonnull
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        return ImmutableSetMultimap.copyOf(this.map);
    }

    @Override
    @Nonnull
    public boolean containsKey(@Nonnull String key) {
        return this.map.containsKey((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
    }

    @Override
    @Nonnull
    public Set<String> getValues(@Nonnull String key) {
        Set values = this.map.get((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    @Nonnull
    public boolean has(@Nonnull String key, @Nonnull String value) {
        return this.map.containsEntry((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern());
    }

    @Override
    @Nonnull
    public boolean hasIgnoreCase(@Nonnull String key, @Nonnull String value) {
        value = ((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern();
        Set values = this.map.get((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
        if (values == null || values.isEmpty()) {
            return false;
        }
        for (String val : values) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public void add(@Nonnull String key, @Nonnull String value) {
        this.map.put((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern());
    }

    public void add(@Nonnull Map.Entry<String, String> entry) {
        Preconditions.checkNotNull(entry, (Object)"entry");
        this.add(entry.getKey(), entry.getValue());
    }

    public void addAll(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        for (Map.Entry e : (Iterable)Preconditions.checkNotNull(iterable, (Object)"iterable")) {
            this.add(e);
        }
    }

    public void addAll(@Nonnull Map<String, String> map) {
        this.addAll(((Map)Preconditions.checkNotNull(map, (Object)"map")).entrySet());
    }

    public void addAll(@Nonnull Multimap<String, String> multimap) {
        this.addAll(((Multimap)Preconditions.checkNotNull(multimap, (Object)"multimap")).entries());
    }

    public void addAll(@Nonnull ContextSet contextSet) {
        Preconditions.checkNotNull((Object)contextSet, (Object)"contextSet");
        if (contextSet instanceof MutableContextSet) {
            MutableContextSet other = (MutableContextSet)contextSet;
            this.map.putAll(other.map);
        } else {
            this.addAll(contextSet.toMultimap());
        }
    }

    public void remove(@Nonnull String key, @Nonnull String value) {
        String k = ((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern();
        String v = ((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern();
        this.map.entries().removeIf(entry -> entry.getKey() == k && entry.getValue() == v);
    }

    public void removeIgnoreCase(@Nonnull String key, @Nonnull String value) {
        String k = ((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern();
        String v = ((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern();
        this.map.entries().removeIf(e -> e.getKey() == k && ((String)e.getValue()).equalsIgnoreCase(v));
    }

    public void removeAll(@Nonnull String key) {
        this.map.removeAll((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Object otherContexts = other instanceof MutableContextSet ? ((MutableContextSet)other).map : other.toMultimap();
        return this.map.equals(otherContexts);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

