/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording.states;

import io.mockk.Invocation;
import io.mockk.InvocationMatcher;
import io.mockk.Matcher;
import io.mockk.MockKException;
import io.mockk.RecordedCall;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.log.Logger;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.recording.CallRound;
import io.mockk.impl.recording.CallRoundBuilder;
import io.mockk.impl.recording.ChildHinter;
import io.mockk.impl.recording.CommonCallRecorder;
import io.mockk.impl.recording.PermanentMocker;
import io.mockk.impl.recording.SignatureMatcherDetector;
import io.mockk.impl.recording.SignedCall;
import io.mockk.impl.recording.states.CallRecordingState;
import io.mockk.impl.recording.states.RecordingState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J1\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00122\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u000fJ\b\u0010%\u001a\u00020\u001cH\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0012H\u0002J\b\u0010+\u001a\u00020\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lio/mockk/impl/recording/states/RecordingState;", "Lio/mockk/impl/recording/states/CallRecordingState;", "recorder", "Lio/mockk/impl/recording/CommonCallRecorder;", "(Lio/mockk/impl/recording/CommonCallRecorder;)V", "callRoundBuilder", "Lio/mockk/impl/recording/CallRoundBuilder;", "callRounds", "", "Lio/mockk/impl/recording/CallRound;", "log", "Lio/mockk/impl/log/Logger;", "getLog", "()Lio/mockk/impl/log/Logger;", "addWasNotCalled", "", "list", "", "", "builder", "call", "invocation", "Lio/mockk/Invocation;", "callIsNumberUnboxing", "", "Lio/mockk/RecordedCall;", "discardLastCallRound", "estimateCallRounds", "", "isLastCallReturnsNothing", "matcher", "T", "Lio/mockk/Matcher;", "cls", "Lkotlin/reflect/KClass;", "(Lio/mockk/Matcher;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "mockPermanently", "nCalls", "round", "total", "signMatchers", "typeEstimation", "it", "workaroundBoxedNumbers", "mockk"})
public abstract class RecordingState
extends CallRecordingState {
    @NotNull
    private final Logger log;
    private CallRoundBuilder callRoundBuilder;
    private final List<CallRound> callRounds;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void round(int round, int total) {
        CallRoundBuilder builder = this.callRoundBuilder;
        if (builder != null) {
            this.callRounds.add(builder.build());
        }
        this.callRoundBuilder = (CallRoundBuilder)this.getRecorder().getFactories().getCallRoundBuilder().invoke();
        this.getRecorder().setChildHinter((ChildHinter)this.getRecorder().getFactories().getChildHinter().invoke());
        if (round == total) {
            this.signMatchers();
            this.workaroundBoxedNumbers();
            this.mockPermanently();
        }
    }

    private final void signMatchers() {
        SignatureMatcherDetector detector = (SignatureMatcherDetector)this.getRecorder().getFactories().getSignatureMatcherDetector().invoke();
        detector.detect(this.callRounds);
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll((Collection<RecordedCall>)detector.getCalls());
    }

    @Override
    @NotNull
    public <T> T matcher(@NotNull Matcher<?> matcher2, @NotNull KClass<T> cls) {
        Intrinsics.checkParameterIsNotNull(matcher2, (String)"matcher");
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        T signatureValue2 = this.getRecorder().getSignatureValueGenerator().signatureValue(cls, (Function0)new Function0<T>(this, cls){
            final /* synthetic */ RecordingState this$0;
            final /* synthetic */ KClass $cls;

            @NotNull
            public final T invoke() {
                Object object = this.this$0.getRecorder().getAnyValueGenerator().anyValue(this.$cls, (Function0<? extends Object>)((Function0)new Function0<T>(this){
                    final /* synthetic */ matcher.signatureValue.1 this$0;

                    @NotNull
                    public final T invoke() {
                        return this.this$0.this$0.getRecorder().getInstantiator().instantiate(this.this$0.$cls);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                return (T)object;
            }
            {
                this.this$0 = recordingState;
                this.$cls = kClass;
                super(0);
            }
        });
        CallRoundBuilder callRoundBuilder = this.builder();
        Object object = InternalPlatform.INSTANCE.packRef(signatureValue2);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        callRoundBuilder.addMatcher(matcher2, object);
        return signatureValue2;
    }

    protected final void addWasNotCalled(@NotNull List<? extends Object> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.builder().addWasNotCalled(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object call(@NotNull Invocation invocation2) {
        void isTemporaryMock;
        Object retValue2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)invocation2, (String)"invocation");
        KClass<?> retType2 = this.getRecorder().getChildHinter().nextChildType((Function0)new Function0<KClass<?>>(invocation2){
            final /* synthetic */ Invocation $invocation;

            @NotNull
            public final KClass<?> invoke() {
                return this.$invocation.getMethod().getReturnType();
            }
            {
                this.$invocation = invocation2;
                super(0);
            }
        });
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (invocation2.getMethod().isToString()) {
            object = this.getRecorder().getStubRepo().get(invocation2.getSelf());
            if (object == null || (object = object.toStr()) == null) {
                object = "";
            }
        } else {
            object = retValue2 = this.getRecorder().getAnyValueGenerator().anyValue(retType2, (Function0<? extends Object>)((Function0)new Function0<Object>(this, (Ref.BooleanRef)isTemporaryMock, retType2){
                final /* synthetic */ RecordingState this$0;
                final /* synthetic */ Ref.BooleanRef $isTemporaryMock;
                final /* synthetic */ KClass $retType;

                @NotNull
                public final Object invoke() {
                    this.$isTemporaryMock.element = true;
                    return this.this$0.getRecorder().getMockFactory().temporaryMock(this.$retType);
                }
                {
                    this.this$0 = recordingState;
                    this.$isTemporaryMock = booleanRef;
                    this.$retType = kClass;
                    super(0);
                }
            }));
        }
        if (retValue2 == null) {
            isTemporaryMock.element = false;
        }
        this.builder().addSignedCall(retValue2, isTemporaryMock.element, retType2, invocation2);
        return retValue2;
    }

    private final boolean callIsNumberUnboxing(RecordedCall call2) {
        InvocationMatcher matcher2 = call2.getMatcher();
        return matcher2.getSelf() instanceof Number && StringsKt.endsWith$default((String)matcher2.getMethod().getName(), (String)"Value", (boolean)false, (int)2, null) && matcher2.getMethod().getParamTypes().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void workaroundBoxedNumbers() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (this.getRecorder().getCalls().size() == 1) {
            return;
        }
        Iterable iterable = $receiver$iv = (Iterable)this.getRecorder().getCalls();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            RecordedCall it = (RecordedCall)element$iv$iv;
            if (this.callIsNumberUnboxing(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List callsWithoutCasts = (List)destination$iv$iv;
        if (callsWithoutCasts.size() != this.getRecorder().getCalls().size()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2 = this.getRecorder().getCalls();
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                RecordedCall it = (RecordedCall)element$iv$iv;
                if (!this.callIsNumberUnboxing(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List callsWithCasts = (List)destination$iv$iv2;
            this.log.debug((Function0<String>)((Function0)new Function0<String>(callsWithCasts){
                final /* synthetic */ List $callsWithCasts;

                @NotNull
                public final String invoke() {
                    return "Removed " + this.$callsWithCasts.size() + " unboxing calls:\n" + CollectionsKt.joinToString$default((Iterable)this.$callsWithCasts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                {
                    this.$callsWithCasts = list;
                    super(0);
                }
            }));
        }
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll(callsWithoutCasts);
    }

    public final void mockPermanently() {
        PermanentMocker mocker = (PermanentMocker)this.getRecorder().getFactories().getPermanentMocker().invoke();
        List<RecordedCall> resultCalls = mocker.mock(this.getRecorder().getCalls());
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll((Collection<RecordedCall>)resultCalls);
    }

    @Override
    public int nCalls() {
        Object object = this.callRoundBuilder;
        return object != null && (object = ((CallRoundBuilder)object).getSignedCalls()) != null ? object.size() : 0;
    }

    @Override
    public boolean isLastCallReturnsNothing() {
        Object object = this.callRoundBuilder;
        if (object == null || (object = ((CallRoundBuilder)object).getSignedCalls()) == null || (object = (SignedCall)CollectionsKt.lastOrNull((List)object)) == null) {
            return false;
        }
        Object lastCall = object;
        return (Boolean)((SignedCall)lastCall).getMethod().getReturnNothing().invoke();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int estimateCallRounds() {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv = this.builder().getSignedCalls();
        Object object = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            SignedCall it = (SignedCall)element$iv$iv;
            Iterable list$iv$iv = it.getArgs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        object = this;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1;
            Object item$iv$iv;
            Object $i$a$1$flatMap = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv2;
            Integer n = ((RecordingState)object).typeEstimation(p1);
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv2));
        return n != null ? n : 1;
    }

    private final int typeEstimation(Object it) {
        KClass kClass = Reflection.getOrCreateKotlinClass(it.getClass());
        return Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? 40 : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? 8 : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) ? 4 : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) ? 4 : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? 2 : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) ? 2 : 1)))));
    }

    @Override
    public void discardLastCallRound() {
        this.callRoundBuilder = null;
    }

    private final CallRoundBuilder builder() {
        CallRoundBuilder callRoundBuilder = this.callRoundBuilder;
        if (callRoundBuilder == null) {
            throw (Throwable)new MockKException("Call builder is not initialized. Bad state", null, 2, null);
        }
        return callRoundBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public RecordingState(@NotNull CommonCallRecorder recorder) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)recorder, (String)"recorder");
        super(recorder);
        Logger.Companion companion = Logger.Companion;
        Object object = recorder.getSafeToString();
        RecordingState recordingState = this;
        Logger logger = (Logger)this_$iv.getLoggerFactory().invoke((Object)Reflection.getOrCreateKotlinClass(RecordingState.class));
        recordingState.log = ((SafeToString)object).invoke(logger);
        recordingState = this;
        recordingState.callRounds = object = (List)new ArrayList();
    }
}

