/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.annotations;

import io.mockk.MockKException;
import io.mockk.impl.annotations.InjectionHelpers;
import io.mockk.impl.annotations.InjectionLookupType;
import io.mockk.impl.annotations.MockInjector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0010\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u001c\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0002J,\u0010\u0017\u001a\u00020\u00062\u0016\u0010\u0018\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00192\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010 H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010 H\u0002J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%H\u0002\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0001J\u0016\u0010*\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%H\u0002J\u0018\u0010+\u001a\u00020\u001b\"\u0004\b\u0000\u0010,*\b\u0012\u0004\u0012\u0002H,0\u0014H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006-"}, d2={"Lio/mockk/impl/annotations/MockInjector;", "", "mockHolder", "lookupType", "Lio/mockk/impl/annotations/InjectionLookupType;", "injectImmutable", "", "overrideValues", "(Ljava/lang/Object;Lio/mockk/impl/annotations/InjectionLookupType;ZZ)V", "getInjectImmutable", "()Z", "getLookupType", "()Lio/mockk/impl/annotations/InjectionLookupType;", "getMockHolder", "()Ljava/lang/Object;", "getOverrideValues", "constructorInjection", "type", "Lkotlin/reflect/KClass;", "findMatchingConstructor", "Lkotlin/reflect/KFunction;", "injectViaConstructor", "firstMatching", "isMatchingType", "it", "Lkotlin/reflect/KProperty1;", "lookupToStr", "", "param", "Lkotlin/reflect/KParameter;", "lookupValueByName", "name", "Lkotlin/reflect/KClassifier;", "lookupValueByType", "matchParameters", "", "parameters", "", "(Ljava/util/List;)[Ljava/lang/Object;", "propertiesInjection", "", "instance", "tryMatchingParameters", "constructorToStr", "R", "mockk"})
public final class MockInjector {
    @NotNull
    private final Object mockHolder;
    @NotNull
    private final InjectionLookupType lookupType;
    private final boolean injectImmutable;
    private final boolean overrideValues;

    @NotNull
    public final Object constructorInjection(@NotNull KClass<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        KFunction<Object> kFunction = this.findMatchingConstructor(type);
        if (kFunction == null) {
            throw (Throwable)new MockKException("No matching constructors found:\n" + CollectionsKt.joinToString$default((Iterable)type.getConstructors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KFunction<? extends Object>, String>(this){
                final /* synthetic */ MockInjector this$0;

                @NotNull
                public final String invoke(@NotNull KFunction<? extends Object> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return MockInjector.access$constructorToStr(this.this$0, it);
                }
                {
                    this.this$0 = mockInjector;
                    super(1);
                }
            }), (int)30, null), null, 2, null);
        }
        KFunction<Object> firstMatching2 = kFunction;
        return this.injectViaConstructor(firstMatching2);
    }

    public final void propertiesInjection(@NotNull Object instance) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Iterable $this$forEach$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(instance.getClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KProperty1 property = (KProperty1)element$iv;
            boolean bl = false;
            boolean isMutable = property instanceof KMutableProperty1;
            if (!this.injectImmutable && !isMutable || !this.overrideValues && InjectionHelpers.INSTANCE.getAnyIfLateNull(property, instance) != null) continue;
            Object object = this.lookupValueByName(property.getName(), property.getReturnType().getClassifier());
            if (object == null) {
                object = this.lookupValueByType(property.getReturnType().getClassifier());
            }
            if (object == null) {
                continue;
            }
            Object newValue = object;
            if (this.injectImmutable && !isMutable) {
                InjectionHelpers.INSTANCE.setImmutableAny(property, instance, newValue);
                continue;
            }
            KProperty1 kProperty1 = property;
            if (kProperty1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<*, *>");
            }
            InjectionHelpers.INSTANCE.setAny((KMutableProperty1)kProperty1, instance, newValue);
        }
    }

    private final Object injectViaConstructor(KFunction<? extends Object> firstMatching2) {
        Object[] objectArray = this.matchParameters(KCallables.getValueParameters((KCallable)((KCallable)firstMatching2)));
        return firstMatching2.call(Arrays.copyOf(objectArray, objectArray.length));
    }

    private final KFunction<Object> findMatchingConstructor(KClass<?> type) {
        Object v0;
        block1: {
            Comparator sortCriteria2 = ComparisonsKt.compareBy((Function1[])new Function1[]{findMatchingConstructor.sortCriteria.1.INSTANCE, findMatchingConstructor.sortCriteria.2.INSTANCE});
            Iterable $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)type.getConstructors(), (Comparator)sortCriteria2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KFunction it = (KFunction)element$iv;
                boolean bl = false;
                if (!this.tryMatchingParameters(KCallables.getValueParameters((KCallable)((KCallable)it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] matchParameters(List<? extends KParameter> parameters) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            KParameter kParameter = (KParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.lookupValueByName(param.getName(), param.getType().getClassifier());
            if (object == null) {
                object = this.lookupValueByType(param.getType().getClassifier());
            }
            if (object == null) {
                throw (Throwable)new MockKException("Parameter unmatched: " + param, null, 2, null);
            }
            Object object2 = object;
            collection.add(object2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryMatchingParameters(List<? extends KParameter> parameters) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = parameters;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void param;
                KParameter kParameter = (KParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object2 = this.lookupValueByName(param.getName(), param.getType().getClassifier());
                if (object2 == null) {
                    object2 = this.lookupValueByType(param.getType().getClassifier());
                }
                Object object3 = object2;
                collection.add(object3);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = object.next();
                    boolean bl3 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final Object lookupValueByName(String name, KClassifier type) {
        Object v0;
        block5: {
            if (name == null) {
                return null;
            }
            if (type == null) {
                return null;
            }
            if (!(type instanceof KClass)) {
                return null;
            }
            if (!this.lookupType.getByName()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(this.mockHolder.getClass()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KProperty1 it = (KProperty1)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && this.isMatchingType((KProperty1<? extends Object, ? extends Object>)it, (KClass)type))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        KProperty1 kProperty1 = v0;
        return kProperty1 != null ? InjectionHelpers.INSTANCE.getAnyIfLateNull(kProperty1, this.mockHolder) : null;
    }

    private final Object lookupValueByType(KClassifier type) {
        Object v0;
        block4: {
            if (type == null) {
                return null;
            }
            if (!(type instanceof KClass)) {
                return null;
            }
            if (!this.lookupType.getByType()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(this.mockHolder.getClass()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KProperty1 it = (KProperty1)element$iv;
                boolean bl = false;
                if (!this.isMatchingType((KProperty1<? extends Object, ? extends Object>)it, (KClass)type)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        KProperty1 kProperty1 = v0;
        return kProperty1 != null ? InjectionHelpers.INSTANCE.getAnyIfLateNull(kProperty1, this.mockHolder) : null;
    }

    private final boolean isMatchingType(KProperty1<? extends Object, ? extends Object> it, KClass<?> type) {
        KClassifier propertyType = it.getReturnType().getClassifier();
        return propertyType instanceof KClass ? KClasses.isSubclassOf((KClass)((KClass)propertyType), type) : false;
    }

    /*
     * WARNING - void declaration
     */
    private final <R> String constructorToStr(@NotNull KFunction<? extends R> $this$constructorToStr) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$constructorToStr.getParameters();
        StringBuilder stringBuilder = new StringBuilder().append("constructor(");
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KParameter kParameter = (KParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            String string = it.getName();
            if (string == null) {
                string = "<noname arg.>";
            }
            String string2 = stringBuilder2.append(string).append(" : ").append(it.getType()).append(" = ").append(this.lookupToStr((KParameter)it)).toString();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(")").toString();
    }

    private final String lookupToStr(KParameter param) {
        Object object;
        Object object2 = this.lookupValueByName(param.getName(), param.getType().getClassifier());
        if (object2 == null) {
            object2 = object = this.lookupValueByType(param.getType().getClassifier());
        }
        if (object2 == null) {
            object = "<not able to lookup>";
        }
        return object.toString();
    }

    @NotNull
    public final Object getMockHolder() {
        return this.mockHolder;
    }

    @NotNull
    public final InjectionLookupType getLookupType() {
        return this.lookupType;
    }

    public final boolean getInjectImmutable() {
        return this.injectImmutable;
    }

    public final boolean getOverrideValues() {
        return this.overrideValues;
    }

    public MockInjector(@NotNull Object mockHolder, @NotNull InjectionLookupType lookupType, boolean injectImmutable, boolean overrideValues) {
        Intrinsics.checkParameterIsNotNull((Object)mockHolder, (String)"mockHolder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)lookupType), (String)"lookupType");
        this.mockHolder = mockHolder;
        this.lookupType = lookupType;
        this.injectImmutable = injectImmutable;
        this.overrideValues = overrideValues;
    }

    public static final /* synthetic */ String access$constructorToStr(MockInjector $this, KFunction $this$access_u24constructorToStr) {
        return $this.constructorToStr($this$access_u24constructorToStr);
    }
}

