/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording;

import io.mockk.impl.recording.SignatureValueGenerator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/mockk/impl/recording/JvmSignatureValueGenerator;", "Lio/mockk/impl/recording/SignatureValueGenerator;", "rnd", "Ljava/util/Random;", "(Ljava/util/Random;)V", "getRnd", "()Ljava/util/Random;", "signatureValue", "T", "", "cls", "Lkotlin/reflect/KClass;", "orInstantiateVia", "Lkotlin/Function0;", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mockk"})
public final class JvmSignatureValueGenerator
implements SignatureValueGenerator {
    @NotNull
    private final Random rnd;

    @Override
    @NotNull
    public <T> T signatureValue(@NotNull KClass<T> cls, @NotNull Function0<? extends T> orInstantiateVia) {
        Object object;
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter(orInstantiateVia, (String)"orInstantiateVia");
        KClass<T> kClass = cls;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.class))) {
            object = this.rnd.nextBoolean();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.class))) {
            object = (byte)this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.class))) {
            object = (short)this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.class))) {
            object = Character.valueOf((char)this.rnd.nextInt());
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.class))) {
            object = this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.class))) {
            object = this.rnd.nextLong();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.class))) {
            object = Float.valueOf(this.rnd.nextFloat());
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.class))) {
            object = this.rnd.nextDouble();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            long l = this.rnd.nextLong();
            int n = 16;
            boolean bl = false;
            String string = Long.toString(l, CharsKt.checkRadix((int)n));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        } else {
            object = orInstantiateVia.invoke();
        }
        return (T)KClasses.cast(cls, (Object)object);
    }

    @NotNull
    public final Random getRnd() {
        return this.rnd;
    }

    public JvmSignatureValueGenerator(@NotNull Random rnd) {
        Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
        this.rnd = rnd;
    }
}

