/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.instantiation;

import io.mockk.MockKGateway;
import io.mockk.impl.stub.MockType;
import io.mockk.impl.stub.SpyKStub;
import io.mockk.impl.stub.Stub;
import io.mockk.impl.stub.StubRepository;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012%\u0010\u0004\u001a!\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R0\u0010\u0004\u001a!\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/mockk/impl/instantiation/CommonMockTypeChecker;", "Lio/mockk/MockKGateway$MockTypeChecker;", "stubRepository", "Lio/mockk/impl/stub/StubRepository;", "isConstructorMockFun", "Lkotlin/Function1;", "Lkotlin/reflect/KClass;", "Lkotlin/ParameterName;", "name", "cls", "", "(Lio/mockk/impl/stub/StubRepository;Lkotlin/jvm/functions/Function1;)V", "()Lkotlin/jvm/functions/Function1;", "getStubRepository", "()Lio/mockk/impl/stub/StubRepository;", "isConstructorMock", "mock", "", "isObjectMock", "isRegularMock", "isSpy", "isStaticMock", "mockk"})
public class CommonMockTypeChecker
implements MockKGateway.MockTypeChecker {
    @NotNull
    private final StubRepository stubRepository;
    @NotNull
    private final Function1<KClass<?>, Boolean> isConstructorMockFun;

    public boolean isRegularMock(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepository.get(mock2);
        if (stub == null) {
            return false;
        }
        Stub stub2 = stub;
        return !(stub2 instanceof SpyKStub);
    }

    public boolean isSpy(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepository.get(mock2);
        if (!(stub instanceof SpyKStub)) {
            stub = null;
        }
        SpyKStub spyKStub = (SpyKStub)stub;
        if (spyKStub == null) {
            return false;
        }
        SpyKStub stub2 = spyKStub;
        return stub2.getMockType() == MockType.SPY;
    }

    public boolean isObjectMock(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepository.get(mock2);
        if (!(stub instanceof SpyKStub)) {
            stub = null;
        }
        SpyKStub spyKStub = (SpyKStub)stub;
        if (spyKStub == null) {
            return false;
        }
        SpyKStub stub2 = spyKStub;
        return stub2.getMockType() == MockType.OBJECT;
    }

    public boolean isStaticMock(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepository.get(mock2);
        if (!(stub instanceof SpyKStub)) {
            stub = null;
        }
        SpyKStub spyKStub = (SpyKStub)stub;
        if (spyKStub == null) {
            return false;
        }
        SpyKStub stub2 = spyKStub;
        return stub2.getMockType() == MockType.STATIC;
    }

    public boolean isConstructorMock(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        return mock2 instanceof KClass ? (Boolean)this.isConstructorMockFun.invoke(mock2) : false;
    }

    @NotNull
    public final StubRepository getStubRepository() {
        return this.stubRepository;
    }

    @NotNull
    public final Function1<KClass<?>, Boolean> isConstructorMockFun() {
        return this.isConstructorMockFun;
    }

    public CommonMockTypeChecker(@NotNull StubRepository stubRepository, @NotNull Function1<? super KClass<?>, Boolean> isConstructorMockFun) {
        Intrinsics.checkNotNullParameter((Object)stubRepository, (String)"stubRepository");
        Intrinsics.checkNotNullParameter(isConstructorMockFun, (String)"isConstructorMockFun");
        this.stubRepository = stubRepository;
        this.isConstructorMockFun = isConstructorMockFun;
    }
}

