/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.Modules;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.maven.project.MavenProject;

class JavaPatcher {
    private final JUnitPlatformMojo mojo;
    private final Configuration configuration;
    private final MavenProject project;
    private final Modules modules;

    JavaPatcher(JUnitPlatformMojo mojo, Configuration configuration) {
        this.mojo = mojo;
        this.project = mojo.getMavenProject();
        this.modules = mojo.getProjectModules();
        this.configuration = configuration;
    }

    void patch(List<String> cmd) {
        String testOutput = this.project.getBuild().getTestOutputDirectory();
        String name = (String)this.modules.getMainModuleName().orElseThrow(AssertionError::new);
        this.mojo.debug("", new Object[0]);
        this.mojo.debug("Patching tests into main module {0} <- {1}", name, testOutput);
        cmd.add("--patch-module");
        cmd.add(name + '=' + testOutput);
        Optional moduleInfoTest = this.configuration.basic().findModuleInfoTest();
        if (moduleInfoTest.isPresent()) {
            Path moduleInfoTestPath = (Path)moduleInfoTest.get();
            this.mojo.debug("Using lines of {0} to patch module {1}...", moduleInfoTestPath, name);
            this.configuration.basic().parseModuleInfoTestLines(cmd::add);
        }
    }
}

