/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Configuration;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ConfigurationBuilder {
    private final Configuration configuration = new Configuration();
    private final DiscoveryBuilder discoveryBuilder = new DiscoveryBuilder();
    private final LauncherBuilder launcherBuilder = new LauncherBuilder();

    public Configuration build() {
        return this.configuration;
    }

    public DiscoveryBuilder discovery() {
        return this.discoveryBuilder;
    }

    public LauncherBuilder launcher() {
        return this.launcherBuilder;
    }

    public ConfigurationBuilder setDryRun(boolean dryRun) {
        this.configuration.basic().dryRun = dryRun;
        return this;
    }

    public ConfigurationBuilder setFailIfNoTests(boolean failIfNoTests) {
        this.configuration.basic().failIfNoTests = failIfNoTests;
        return this;
    }

    public ConfigurationBuilder setPlatformClassLoader(boolean platformClassLoader) {
        this.configuration.basic().platformClassLoader = platformClassLoader;
        return this;
    }

    public ConfigurationBuilder setDefaultAssertionStatus(boolean defaultAssertionStatus) {
        this.configuration.basic().defaultAssertionStatus = defaultAssertionStatus;
        return this;
    }

    public ConfigurationBuilder setTargetDirectory(String targetDirectory) {
        this.configuration.basic().targetDirectory = targetDirectory;
        return this;
    }

    public ConfigurationBuilder setWorkerCoordinates(String workerCoordinates) {
        this.configuration.basic().workerCoordinates = workerCoordinates;
        return this;
    }

    public ConfigurationBuilder setWorkerClassName(String workerClassName) {
        this.configuration.basic().workerClassName = workerClassName;
        return this;
    }

    public ConfigurationBuilder setWorkerIsolationRequired(boolean workerIsolationRequired) {
        this.configuration.basic().workerIsolationRequired = workerIsolationRequired;
        return this;
    }

    public ConfigurationBuilder setPaths(Map<String, Set<String>> paths) {
        this.configuration.basic().paths = paths;
        return this;
    }

    public ConfigurationBuilder setTargetMainPath(String targetMainPath) {
        this.configuration.basic().targetMainPath = targetMainPath;
        return this;
    }

    public ConfigurationBuilder setTargetTestPath(String targetTestPath) {
        this.configuration.basic().targetTestPath = targetTestPath;
        return this;
    }

    public ConfigurationBuilder setModuleInfoTestPath(String moduleInfoTestPath) {
        this.configuration.basic().moduleInfoTestPath = moduleInfoTestPath;
        return this;
    }

    public class LauncherBuilder {
        public ConfigurationBuilder end() {
            return ConfigurationBuilder.this;
        }

        public LauncherBuilder setTestEngineAutoRegistration(boolean enabled) {
            ((ConfigurationBuilder)ConfigurationBuilder.this).configuration.launcher().testEngineAutoRegistration = enabled;
            return this;
        }

        public LauncherBuilder setTestExecutionListenerAutoRegistration(boolean enabled) {
            ((ConfigurationBuilder)ConfigurationBuilder.this).configuration.launcher().testExecutionListenerAutoRegistration = enabled;
            return this;
        }
    }

    public class DiscoveryBuilder {
        private final Configuration.Discovery discovery;

        public DiscoveryBuilder() {
            this.discovery = ConfigurationBuilder.this.configuration.discovery();
        }

        public ConfigurationBuilder end() {
            return ConfigurationBuilder.this;
        }

        public DiscoveryBuilder setSelectedUris(Set<URI> selectedUris) {
            this.discovery.selectedUris = selectedUris;
            return this;
        }

        public DiscoveryBuilder addSelectedUris(Collection<URI> uris) {
            if (this.discovery.selectedUris == Collections.EMPTY_SET) {
                return this.setSelectedUris(new LinkedHashSet<URI>(uris));
            }
            this.discovery.selectedUris.addAll(uris);
            return this;
        }

        public DiscoveryBuilder addSelectedUris(URI ... uris) {
            return this.addSelectedUris(Arrays.asList(uris));
        }

        public DiscoveryBuilder setSelectedFiles(Set<String> selectedFiles) {
            this.discovery.selectedFiles = selectedFiles;
            return this;
        }

        public DiscoveryBuilder addSelectedFiles(Collection<String> files) {
            if (this.discovery.selectedFiles == Collections.EMPTY_SET) {
                return this.setSelectedFiles(new LinkedHashSet<String>(files));
            }
            this.discovery.selectedFiles.addAll(files);
            return this;
        }

        public DiscoveryBuilder addSelectedFiles(String ... files) {
            return this.addSelectedFiles(Arrays.asList(files));
        }

        public DiscoveryBuilder setSelectedDirectories(Set<String> selectedDirectories) {
            this.discovery.selectedDirectories = selectedDirectories;
            return this;
        }

        public DiscoveryBuilder addSelectedDirectories(Collection<String> directories) {
            if (this.discovery.selectedDirectories == Collections.EMPTY_SET) {
                return this.setSelectedDirectories(new LinkedHashSet<String>(directories));
            }
            this.discovery.selectedDirectories.addAll(directories);
            return this;
        }

        public DiscoveryBuilder addSelectedDirectories(String ... directories) {
            return this.addSelectedDirectories(Arrays.asList(directories));
        }

        public DiscoveryBuilder setSelectedPackages(Set<String> selectedPackages) {
            this.discovery.selectedPackages = selectedPackages;
            return this;
        }

        public DiscoveryBuilder addSelectedPackages(Collection<String> packages) {
            if (this.discovery.selectedPackages == Collections.EMPTY_SET) {
                return this.setSelectedPackages(new LinkedHashSet<String>(packages));
            }
            this.discovery.selectedPackages.addAll(packages);
            return this;
        }

        public DiscoveryBuilder addSelectedPackages(String ... packages) {
            return this.addSelectedPackages(Arrays.asList(packages));
        }

        public DiscoveryBuilder setSelectedClasses(Set<String> selectedClasses) {
            this.discovery.selectedClasses = selectedClasses;
            return this;
        }

        public DiscoveryBuilder addSelectedClasses(Collection<String> classes) {
            if (this.discovery.selectedClasses == Collections.EMPTY_SET) {
                return this.setSelectedClasses(new LinkedHashSet<String>(classes));
            }
            this.discovery.selectedClasses.addAll(classes);
            return this;
        }

        public DiscoveryBuilder addSelectedClasses(String ... classes) {
            return this.addSelectedClasses(Arrays.asList(classes));
        }

        public DiscoveryBuilder setSelectedMethods(Set<String> selectedMethods) {
            this.discovery.selectedMethods = selectedMethods;
            return this;
        }

        public DiscoveryBuilder addSelectedMethods(Collection<String> methods) {
            if (this.discovery.selectedMethods == Collections.EMPTY_SET) {
                return this.setSelectedMethods(new LinkedHashSet<String>(methods));
            }
            this.discovery.selectedMethods.addAll(methods);
            return this;
        }

        public DiscoveryBuilder addSelectedMethods(String ... methods) {
            return this.addSelectedMethods(Arrays.asList(methods));
        }

        public DiscoveryBuilder setSelectedClasspathResources(Set<String> selectedClasspathResources) {
            this.discovery.selectedClasspathResources = selectedClasspathResources;
            return this;
        }

        public DiscoveryBuilder addSelectedClasspathResources(Collection<String> resources) {
            if (this.discovery.selectedClasspathResources == Collections.EMPTY_SET) {
                return this.setSelectedClasspathResources(new LinkedHashSet<String>(resources));
            }
            this.discovery.selectedClasspathResources.addAll(resources);
            return this;
        }

        public DiscoveryBuilder addSelectedClasspathResources(String ... resources) {
            return this.addSelectedClasspathResources(Arrays.asList(resources));
        }

        public DiscoveryBuilder setSelectedClasspathRoots(Set<String> selectedClasspathRoots) {
            this.discovery.selectedClasspathRoots = selectedClasspathRoots;
            return this;
        }

        public DiscoveryBuilder addSelectedClasspathRoots(Collection<String> roots) {
            if (this.discovery.selectedClasspathRoots == Collections.EMPTY_SET) {
                return this.setSelectedClasspathRoots(new LinkedHashSet<String>(roots));
            }
            this.discovery.selectedClasspathRoots.addAll(roots);
            return this;
        }

        public DiscoveryBuilder addSelectedClasspathRoots(String ... roots) {
            return this.addSelectedClasspathRoots(Arrays.asList(roots));
        }

        public DiscoveryBuilder setSelectedModules(Set<String> selectedModules) {
            this.discovery.selectedModules = selectedModules;
            return this;
        }

        public DiscoveryBuilder addSelectedModules(Collection<String> modules) {
            if (this.discovery.selectedModules == Collections.EMPTY_SET) {
                return this.setSelectedModules(new LinkedHashSet<String>(modules));
            }
            this.discovery.selectedModules.addAll(modules);
            return this;
        }

        public DiscoveryBuilder addSelectedModules(String ... modules) {
            return this.addSelectedModules(Arrays.asList(modules));
        }

        public DiscoveryBuilder setFilterClassNamePatterns(Set<String> filterClassNamePatterns) {
            this.discovery.filterClassNamePatterns = filterClassNamePatterns;
            return this;
        }

        public DiscoveryBuilder addFilterClassNamePatterns(Collection<String> patterns) {
            if (this.discovery.filterClassNamePatterns == Collections.EMPTY_SET) {
                return this.setFilterClassNamePatterns(new LinkedHashSet<String>(patterns));
            }
            this.discovery.filterClassNamePatterns.addAll(patterns);
            return this;
        }

        public DiscoveryBuilder addFilterClassNamePatterns(String ... patterns) {
            return this.addFilterClassNamePatterns(Arrays.asList(patterns));
        }

        public DiscoveryBuilder setFilterTags(Set<String> filterTags) {
            this.discovery.filterTags = filterTags;
            return this;
        }

        public DiscoveryBuilder addFilterTags(Collection<String> tags) {
            if (this.discovery.filterTags == Collections.EMPTY_SET) {
                return this.setFilterTags(new LinkedHashSet<String>(tags));
            }
            this.discovery.filterTags.addAll(tags);
            return this;
        }

        public DiscoveryBuilder addFilterTags(String ... tags) {
            return this.addFilterTags(Arrays.asList(tags));
        }

        public DiscoveryBuilder setParameters(Map<String, String> parameters) {
            this.discovery.parameters = parameters;
            return this;
        }

        public DiscoveryBuilder addParameter(String key, String value) {
            if (this.discovery.parameters == Collections.EMPTY_MAP) {
                this.discovery.parameters = new LinkedHashMap<String, String>();
            }
            this.discovery.parameters.put(key, value);
            return this;
        }
    }
}

