/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.ModuleLayerUpdater;
import de.sormuras.junit.platform.isolator.Overlay;
import de.sormuras.junit.platform.isolator.TargetModuleCollector;
import de.sormuras.junit.platform.isolator.TestMode;
import java.lang.module.ModuleFinder;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum OverlaySingleton implements Overlay
{
    INSTANCE{

        @Override
        public URLClassLoader newClassLoader(String name, ClassLoader parent, URL ... urls) {
            return new URLClassLoader(name, urls, parent);
        }

        @Override
        public ClassLoader newModuleLoader(Driver driver, Configuration configuration, ClassLoader parentLoader) {
            Set<String> selectedModules = configuration.discovery().getSelectedModules();
            if (selectedModules.isEmpty()) {
                throw new IllegalStateException("No module selected!");
            }
            Configuration.Basic basic = configuration.basic();
            boolean patch = basic.toModules().getMode() == TestMode.MODULAR_PATCHED_TEST_RUNTIME;
            Path[] entries = (Path[])basic.toPaths().values().stream().flatMap(Collection::stream).distinct().toArray(Path[]::new);
            ModuleFinder finder = ModuleFinder.of(entries);
            LinkedHashSet<String> roots = new LinkedHashSet<String>(selectedModules);
            if (patch) {
                TargetModuleCollector collector = new TargetModuleCollector(driver);
                basic.parseModuleInfoTestLines(collector);
                roots.addAll(collector.getTargets());
            }
            java.lang.module.Configuration moduleConfig = ModuleLayer.boot().configuration().resolve(finder, ModuleFinder.of(new Path[0]), roots);
            List<ModuleLayer> parentLayers = List.of(ModuleLayer.boot());
            ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(moduleConfig, parentLayers, parentLoader);
            if (patch) {
                basic.parseModuleInfoTestLines(new ModuleLayerUpdater(driver, controller));
            }
            String name = selectedModules.toArray()[0].toString();
            return controller.layer().findLoader(name);
        }

        @Override
        public ClassLoader platformClassLoader() {
            return ClassLoader.getPlatformClassLoader();
        }
    };

}

