/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.AbstractModuleInfoTestConsumer;
import de.sormuras.junit.platform.isolator.Driver;
import java.util.Arrays;
import java.util.function.Supplier;

class ModuleLayerUpdater
extends AbstractModuleInfoTestConsumer {
    private final ModuleLayer.Controller controller;

    ModuleLayerUpdater(Driver driver, ModuleLayer.Controller controller) {
        super(driver);
        this.controller = controller;
    }

    @Override
    public void accept(String option, String sourceName, String packageName, String[] targetNames) {
        this.driver.debug("Updating module layer: {0} `{1}[/{2}]`=`{3}`", sourceName, packageName, Arrays.asList(targetNames));
        ModuleLayer layer = this.controller.layer();
        Module source = layer.findModule(sourceName).orElseThrow(ModuleLayerUpdater.moduleNotFound(sourceName));
        block10: for (String targetName : targetNames) {
            Module target = layer.findModule(targetName).orElseThrow(ModuleLayerUpdater.moduleNotFound(targetName));
            switch (option) {
                case "--add-exports": {
                    this.controller.addExports(source, packageName, target);
                    continue block10;
                }
                case "--add-opens": {
                    this.controller.addOpens(source, packageName, target);
                    continue block10;
                }
                case "--add-reads": {
                    this.controller.addReads(source, target);
                    continue block10;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown option: " + option);
                }
            }
        }
    }

    private static Supplier<AssertionError> moduleNotFound(String name) {
        return () -> new AssertionError((Object)("Module with name `" + name + "` not found!"));
    }
}

