//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readUtf8CodePoint](read-utf8-code-point.md)

# readUtf8CodePoint

[common]\
abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary.

If this source is exhausted before a complete code point can be read, this throws an java.io.EOFException and consumes no input.

If this source doesn't start with a properly-encoded UTF-8 code point, this method will remove 1 or more non-UTF-8 bytes and return the replacement character (U+FFFD). This covers encoding problems (the input is not properly-encoded UTF-8), characters out of range (beyond the 0x10ffff limit of Unicode), code points for UTF-16 surrogates (U+d800..U+dfff) and overlong encodings (such as 0xc080 for the NUL character in modified UTF-8).

[jvm]\
abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)
