//[okio](../../index.md)/[okio](../index.md)/[Throttler](index.md)



# Throttler  
 [jvm] Enables limiting of Source and Sink throughput. Attach to this throttler via [source](source.md) and [sink](sink.md) and set the desired throughput via [bytesPerSecond](bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers.This class has these tuning parameters:<ul><li>bytesPerSecond: Maximum sustained throughput. Use 0 for no limit.</li><li>waitByteCount: When the requested byte count is greater than this many bytes and isn't     immediately available, only wait until we can allocate at least this many bytes. Use this to     set the ideal byte count during sustained throughput.</li><li>maxByteCount: Maximum number of bytes to allocate on any call. This is also the number of     bytes that will be returned before any waiting.</li></ul>  
  
class [Throttler](index.md)   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| [<init>](-init-.md)|  [jvm] fun [<init>](-init-.md)()   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [bytesPerSecond](bytes-per-second.md)| [jvm]  <br>Brief description  <br>Sets the rate at which bytes will be allocated. Use 0 for no limit.  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [bytesPerSecond](bytes-per-second.md)(bytesPerSecond: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), waitByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), maxByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [sink](sink.md)| [jvm]  <br>Brief description  <br>Create a Sink which honors this Throttler.  <br>Content  <br>fun [sink](sink.md)(sink: [Sink](../-sink/index.md)): [Sink](../-sink/index.md)  <br><br><br>
| [source](source.md)| [jvm]  <br>Brief description  <br>Create a Source which honors this Throttler.  <br>Content  <br>fun [source](source.md)(source: [Source](../-source/index.md)): [Source](../-source/index.md)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [jvm]  <br>Content  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>

