//[okio](../../index.md)/[okio](../index.md)/[InflaterSource](index.md)



# InflaterSource  
 [jvm] A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.  
  
class [InflaterSource](index.md) : [Source](../-source/index.md)   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| [<init>](-init-.md)|  [jvm] fun [<init>](-init-.md)(source: [Source](../-source/index.md), inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [close](close.md)| [jvm]  <br>Content  <br>open override fun [close](close.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [read](read.md)| [jvm]  <br>Content  <br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readOrInflate](read-or-inflate.md)| [jvm]  <br>Brief description  <br>Consume deflated bytes from the underlying source, and write any inflated bytes to [sink](). Returns the number of inflated bytes written to [sink](). This may return 0L, though it will always consume 1 or more bytes from the underlying source if it is not exhausted.Use this instead of [read](read.md) when it is useful to consume the deflated stream even when doing so doesn't yield inflated bytes.  <br>Content  <br>fun [readOrInflate](read-or-inflate.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [refill](refill.md)| [jvm]  <br>Brief description  <br>Refills the inflater with compressed data if it needs input. (And only if it needs input). Returns true if the inflater required input but the source was exhausted.  <br>Content  <br>fun [refill](refill.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [timeout](timeout.md)| [jvm]  <br>Content  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [jvm]  <br>Content  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>

