//[okio](../../index.md)/[okio](../index.md)/[HashingSink](index.md)



# HashingSink  
 [jvm] A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](index.md#okio/HashingSink/hash/#/PointingToDeclaration/) to compute the final hash value.In this example we use HashingSink with a [BufferedSink](../-buffered-sink/index.md) to make writing to the sink easier.HashingSink hashingSink = HashingSink.sha256(s);  
BufferedSink bufferedSink = Okio.buffer(hashingSink);  
  
... // Write to bufferedSink and either flush or close it.  
  
ByteString hash = hashingSink.hash();  
  
class [HashingSink](index.md) : [ForwardingSink](../-forwarding-sink/index.md)   


## Types  
  
|  Name|  Summary| 
|---|---|
| [Companion](-companion/index.md)| [jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [close](../-forwarding-sink/close.md)| [jvm]  <br>Content  <br>open override fun [close](../-forwarding-sink/close.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [flush](../-forwarding-sink/flush.md)| [jvm]  <br>Content  <br>open override fun [flush](../-forwarding-sink/flush.md)()  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [timeout](../-forwarding-sink/timeout.md)| [jvm]  <br>Content  <br>open override fun [timeout](../-forwarding-sink/timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](../-forwarding-sink/to-string.md)| [jvm]  <br>Content  <br>open override fun [toString](../-forwarding-sink/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [write](write.md)| [jvm]  <br>Content  <br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [delegate](index.md#okio/HashingSink/delegate/#/PointingToDeclaration/)|  [jvm] [Sink](../-sink/index.md) to which this instance is delegating.override val [delegate](index.md#okio/HashingSink/delegate/#/PointingToDeclaration/): [Sink](../-sink/index.md)   <br>
| [hash](index.md#okio/HashingSink/hash/#/PointingToDeclaration/)|  [jvm] Returns the hash of the bytes accepted thus far and resets the internal state of this sink. This method is not idempotent. Each time this method is called its internal state is cleared. This starts a new hash with zero bytes accepted.val [hash](index.md#okio/HashingSink/hash/#/PointingToDeclaration/): [ByteString](../-byte-string/index.md)   <br>

