/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertyUpdater;
import com.netflix.config.PollListener;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPollingScheduler {
    private volatile boolean ignoreDeletesFromSource;
    private List<PollListener> listeners = new CopyOnWriteArrayList<PollListener>();
    private volatile Object checkPoint;
    private static Logger log = LoggerFactory.getLogger(AbstractPollingScheduler.class);
    private DynamicPropertyUpdater propertyUpdater = new DynamicPropertyUpdater();

    public AbstractPollingScheduler(boolean ignoreDeletesFromSource) {
        this.ignoreDeletesFromSource = ignoreDeletesFromSource;
    }

    public AbstractPollingScheduler() {
        this.ignoreDeletesFromSource = false;
    }

    protected synchronized void initialLoad(PolledConfigurationSource source, Configuration config) {
        PollResult result = null;
        try {
            this.fireEvent(PollListener.EventType.POLL_BEGIN, null, null);
            result = source.poll(true, null);
            this.checkPoint = result.getCheckPoint();
            try {
                this.populateProperties(result, config);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load Properties", e);
            }
            this.fireEvent(PollListener.EventType.POLL_SUCCESS, result, null);
        }
        catch (Exception e) {
            this.fireEvent(PollListener.EventType.POLL_FAILURE, null, e);
            throw new RuntimeException("Unable to load Properties source from " + source, e);
        }
    }

    protected void populateProperties(PollResult result, Configuration config) {
        block12: {
            block11: {
                if (result == null || !result.hasChanges()) {
                    return;
                }
                if (result.isIncremental()) break block11;
                Map<String, Object> props = result.getComplete();
                if (props == null) {
                    return;
                }
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.propertyUpdater.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
                HashSet existingKeys = new HashSet();
                Iterator i = config.getKeys();
                while (i.hasNext()) {
                    existingKeys.add(i.next());
                }
                if (this.ignoreDeletesFromSource) break block12;
                for (String key : existingKeys) {
                    if (props.containsKey(key)) continue;
                    this.propertyUpdater.deleteProperty(key, config);
                }
                break block12;
            }
            Map<String, Object> props = result.getAdded();
            if (props != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.propertyUpdater.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
            }
            if ((props = result.getChanged()) != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.propertyUpdater.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
            }
            if (!this.ignoreDeletesFromSource && (props = result.getDeleted()) != null) {
                for (String name : props.keySet()) {
                    this.propertyUpdater.deleteProperty(name, config);
                }
            }
        }
    }

    protected Runnable getPollingRunnable(final PolledConfigurationSource source, final Configuration config) {
        return new Runnable(){

            @Override
            public void run() {
                log.debug("Polling started");
                PollResult result = null;
                try {
                    AbstractPollingScheduler.this.fireEvent(PollListener.EventType.POLL_BEGIN, null, null);
                    result = source.poll(false, AbstractPollingScheduler.this.getNextCheckPoint(AbstractPollingScheduler.this.checkPoint));
                    AbstractPollingScheduler.this.checkPoint = result.getCheckPoint();
                    try {
                        AbstractPollingScheduler.this.populateProperties(result, config);
                    }
                    catch (Exception e) {
                        log.error("Error applying properties", (Throwable)e);
                    }
                    AbstractPollingScheduler.this.fireEvent(PollListener.EventType.POLL_SUCCESS, result, null);
                }
                catch (Exception e) {
                    log.error("Error getting result from polling source", (Throwable)e);
                    AbstractPollingScheduler.this.fireEvent(PollListener.EventType.POLL_FAILURE, null, e);
                }
            }
        };
    }

    private void fireEvent(PollListener.EventType eventType, PollResult result, Throwable e) {
        for (PollListener l : this.listeners) {
            try {
                l.handleEvent(eventType, result, e);
            }
            catch (Throwable ex) {
                log.error("Error in invoking listener", ex);
            }
        }
    }

    public void startPolling(PolledConfigurationSource source, Configuration config) {
        this.initialLoad(source, config);
        Runnable r = this.getPollingRunnable(source, config);
        this.schedule(r);
    }

    public void addPollListener(PollListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removePollListener(PollListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    protected Object getNextCheckPoint(Object lastCheckpoint) {
        return lastCheckpoint;
    }

    protected abstract void schedule(Runnable var1);

    public abstract void stop();

    public final boolean isIgnoreDeletesFromSource() {
        return this.ignoreDeletesFromSource;
    }

    public final void setIgnoreDeletesFromSource(boolean ignoreDeletesFromSource) {
        this.ignoreDeletesFromSource = ignoreDeletesFromSource;
    }
}

