/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Calscale;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.PartialDate;
import ezvcard.util.VCardDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DateOrTimeProperty
extends VCardProperty
implements HasAltId {
    private String text;
    private Calendar date;
    private PartialDate partialDate;
    private boolean dateHasTime;

    public DateOrTimeProperty(Date date) {
        this(VCardDateFormat.toCalendar(date));
    }

    public DateOrTimeProperty(Date date, boolean hasTime) {
        this.setDate(date, hasTime);
    }

    public DateOrTimeProperty(Calendar date) {
        this(date, false);
    }

    public DateOrTimeProperty(Calendar date, boolean hasTime) {
        this.setDate(date, hasTime);
    }

    public DateOrTimeProperty(PartialDate partialDate) {
        this.setPartialDate(partialDate);
    }

    public DateOrTimeProperty(String text) {
        this.setText(text);
    }

    public DateOrTimeProperty(DateOrTimeProperty original) {
        super(original);
        this.text = original.text;
        this.date = original.date == null ? null : (Calendar)original.date.clone();
        this.partialDate = original.partialDate;
        this.dateHasTime = original.dateHasTime;
    }

    public Date getDate() {
        return this.date == null ? null : this.date.getTime();
    }

    public void setDate(Date date, boolean hasTime) {
        this.setDate(VCardDateFormat.toCalendar(date), hasTime);
    }

    public void setDate(Calendar date, boolean hasTime) {
        this.date = date;
        this.dateHasTime = date != null && hasTime;
        this.text = null;
        this.partialDate = null;
    }

    public Calendar getCalendar() {
        return this.date == null ? null : (Calendar)this.date.clone();
    }

    public PartialDate getPartialDate() {
        return this.partialDate;
    }

    public void setPartialDate(PartialDate partialDate) {
        this.partialDate = partialDate;
        this.dateHasTime = partialDate != null && partialDate.hasTimeComponent();
        this.text = null;
        this.date = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.date = null;
        this.partialDate = null;
        this.dateHasTime = false;
    }

    public boolean hasTime() {
        return this.dateHasTime;
    }

    public Calscale getCalscale() {
        return this.parameters.getCalscale();
    }

    public void setCalscale(Calscale calscale) {
        this.parameters.setCalscale(calscale);
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.date == null && this.partialDate == null && this.text == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
        if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
            if (this.text != null) {
                warnings.add(new ValidationWarning(11, new Object[0]));
            }
            if (this.partialDate != null) {
                warnings.add(new ValidationWarning(12, new Object[0]));
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("text", this.text);
        values.put("date", this.getDate());
        values.put("dateHasTime", this.dateHasTime);
        values.put("partialDate", this.partialDate);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getDate() == null ? 0 : this.getDate().hashCode());
        result = 31 * result + (this.dateHasTime ? 1231 : 1237);
        result = 31 * result + (this.partialDate == null ? 0 : this.partialDate.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateOrTimeProperty other = (DateOrTimeProperty)obj;
        if (this.getDate() == null ? other.getDate() != null : !this.getDate().equals(other.getDate())) {
            return false;
        }
        if (this.dateHasTime != other.dateHasTime) {
            return false;
        }
        if (this.partialDate == null ? other.partialDate != null : !this.partialDate.equals(other.partialDate)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

