/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.BinaryPropertyScribe;
import ezvcard.parameter.SoundType;
import ezvcard.property.Sound;
import ezvcard.util.DataUri;
import org.jsoup.nodes.Element;

public class SoundScribe
extends BinaryPropertyScribe<Sound, SoundType> {
    public SoundScribe() {
        super(Sound.class, "SOUND");
    }

    @Override
    protected SoundType _mediaTypeFromTypeParameter(String type) {
        return SoundType.get(type, null, null);
    }

    @Override
    protected SoundType _mediaTypeFromMediaTypeParameter(String mediaType) {
        return SoundType.get(null, mediaType, null);
    }

    @Override
    protected SoundType _mediaTypeFromFileExtension(String extension) {
        return SoundType.find(null, null, extension);
    }

    @Override
    protected Sound _newInstance(String uri, SoundType contentType) {
        return new Sound(uri, contentType);
    }

    @Override
    protected Sound _newInstance(byte[] data, SoundType contentType) {
        return new Sound(data, contentType);
    }

    @Override
    protected Sound _parseHtml(HCardElement element, ParseContext context) {
        String src;
        String elementName = element.tagName();
        if (!"audio".equals(elementName) && !"source".equals(elementName)) {
            return (Sound)super._parseHtml(element, context);
        }
        if ("audio".equals(elementName)) {
            Element source = element.getElement().getElementsByTag("source").first();
            if (source == null) {
                throw new CannotParseException(16, new Object[0]);
            }
            element = new HCardElement(source);
        }
        if ((src = element.absUrl("src")).isEmpty()) {
            throw new CannotParseException(17, new Object[0]);
        }
        String type = element.attr("type");
        SoundType mediaType = type.isEmpty() ? null : this._mediaTypeFromMediaTypeParameter(type);
        try {
            DataUri uri = DataUri.parse(src);
            mediaType = this._mediaTypeFromMediaTypeParameter(uri.getContentType());
            return new Sound(uri.getData(), mediaType);
        }
        catch (IllegalArgumentException e) {
            if (mediaType == null) {
                String extension = SoundScribe.getFileExtension(src);
                mediaType = extension == null ? null : this._mediaTypeFromFileExtension(extension);
            }
            return new Sound(src, mediaType);
        }
    }
}

