/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.RawProperty;
import java.util.List;

public class RawPropertyScribe
extends VCardPropertyScribe<RawProperty> {
    public RawPropertyScribe(String propertyName) {
        super(RawProperty.class, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return null;
    }

    @Override
    protected VCardDataType _dataType(RawProperty property, VCardVersion version) {
        return property.getDataType();
    }

    @Override
    protected String _writeText(RawProperty property, WriteContext context) {
        String value = (String)property.getValue();
        return value == null ? "" : value;
    }

    @Override
    protected RawProperty _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        RawProperty property = new RawProperty(this.propertyName, value);
        property.setDataType(dataType);
        return property;
    }

    @Override
    protected RawProperty _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        XCardElement.XCardValue firstValue = element.firstValue();
        VCardDataType dataType = firstValue.getDataType();
        String value = firstValue.getValue();
        RawProperty property = new RawProperty(this.propertyName, value);
        property.setDataType(dataType);
        return property;
    }

    @Override
    protected RawProperty _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = RawPropertyScribe.jcardValueToString(value);
        RawProperty property = new RawProperty(this.propertyName, valueStr);
        property.setDataType(dataType);
        return property;
    }

    @Override
    protected RawProperty _parseHtml(HCardElement element, ParseContext context) {
        String value = element.value();
        return new RawProperty(this.propertyName, value);
    }

    private static String jcardValueToString(JCardValue value) {
        List<List<String>> structured;
        List<String> multi;
        List<JsonValue> values = value.getValues();
        if (values.size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return VObjectPropertyValues.writeList(multi);
        }
        if (!values.isEmpty() && values.get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return VObjectPropertyValues.writeStructured(structured, (boolean)true);
        }
        return value.asSingle();
    }
}

