/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.StringPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Email;
import java.util.List;

public class EmailScribe
extends StringPropertyScribe<Email> {
    public EmailScribe() {
        super(Email.class, "EMAIL");
    }

    @Override
    protected void _prepareParameters(Email property, VCardParameters copy, VCardVersion version, VCard vcard) {
        EmailScribe.handlePrefParam(property, copy, version, vcard);
    }

    @Override
    protected Email _parseValue(String value) {
        return new Email(value);
    }

    @Override
    protected Email _parseHtml(HCardElement element, ParseContext context) {
        String href = element.attr("href");
        String email = EmailScribe.extractEmailFromHrefAttribute(href);
        if (email == null) {
            email = element.value();
        }
        Email property = new Email(email);
        List<String> types = element.types();
        property.getParameters().putAll("TYPE", types);
        return property;
    }

    private static String extractEmailFromHrefAttribute(String value) {
        int colon = value.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String scheme = value.substring(0, colon);
        return scheme.equalsIgnoreCase("mailto") ? value.substring(colon + 1) : null;
    }
}

