/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.Messages;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.ParseContext;
import ezvcard.io.SkipMeException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Agent;
import ezvcard.property.VCardProperty;
import java.util.Set;

public class AgentScribe
extends VCardPropertyScribe<Agent> {
    public AgentScribe() {
        super(Agent.class, "AGENT");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return null;
    }

    @Override
    protected VCardDataType _dataType(Agent property, VCardVersion version) {
        if (property.getUrl() != null) {
            return version == VCardVersion.V2_1 ? VCardDataType.URL : VCardDataType.URI;
        }
        return null;
    }

    @Override
    protected String _writeText(Agent property, WriteContext context) {
        String url = property.getUrl();
        if (url != null) {
            return url;
        }
        VCard vcard = property.getVCard();
        if (vcard != null) {
            throw new EmbeddedVCardException(vcard);
        }
        throw new SkipMeException(Messages.INSTANCE.getValidationWarning(8, new Object[0]));
    }

    @Override
    protected Agent _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        Agent property = new Agent();
        if (dataType == null) {
            throw new EmbeddedVCardException(new Injector(property));
        }
        property.setUrl(VObjectPropertyValues.unescape((String)value));
        return property;
    }

    @Override
    protected Agent _parseHtml(HCardElement element, ParseContext context) {
        Agent property = new Agent();
        Set<String> classes = element.classNames();
        if (classes.contains("vcard")) {
            throw new EmbeddedVCardException(new Injector(property));
        }
        String url = element.absUrl("href");
        if (url.isEmpty()) {
            url = element.value();
        }
        property.setUrl(url);
        return property;
    }

    private static class Injector
    implements EmbeddedVCardException.InjectionCallback {
        private final Agent property;

        public Injector(Agent property) {
            this.property = property;
        }

        @Override
        public void injectVCard(VCard vcard) {
            this.property.setVCard(vcard);
        }

        @Override
        public VCardProperty getProperty() {
            return this.property;
        }
    }
}

