/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.pubsub.PubSubResponsePayloadMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import lombok.Generated;

public interface TopicHandler
extends Function<Args, TwitchEvent> {
    public String topicName();

    default public Collection<String> topicNames() {
        return Collections.singletonList(this.topicName());
    }

    public static final class Args {
        private final String[] topicParts;
        private final PubSubResponsePayloadMessage message;
        private final Collection<String> botOwnerIds;

        public String getType() {
            return this.message.getType();
        }

        public JsonNode getData() {
            return this.message.getMessageData();
        }

        public String getRawMessage() {
            return this.message.getRawMessage();
        }

        public String getLastTopicPart() {
            return this.topicParts[this.topicParts.length - 1];
        }

        @Generated
        public Args(String[] topicParts, PubSubResponsePayloadMessage message, Collection<String> botOwnerIds) {
            this.topicParts = topicParts;
            this.message = message;
            this.botOwnerIds = botOwnerIds;
        }

        @Generated
        public String[] getTopicParts() {
            return this.topicParts;
        }

        @Generated
        public PubSubResponsePayloadMessage getMessage() {
            return this.message;
        }

        @Generated
        public Collection<String> getBotOwnerIds() {
            return this.botOwnerIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Args)) {
                return false;
            }
            Args other = (Args)o;
            if (!Arrays.deepEquals(this.getTopicParts(), other.getTopicParts())) {
                return false;
            }
            PubSubResponsePayloadMessage this$message = this.getMessage();
            PubSubResponsePayloadMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Collection<String> this$botOwnerIds = this.getBotOwnerIds();
            Collection<String> other$botOwnerIds = other.getBotOwnerIds();
            return !(this$botOwnerIds == null ? other$botOwnerIds != null : !((Object)this$botOwnerIds).equals(other$botOwnerIds));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getTopicParts());
            PubSubResponsePayloadMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Collection<String> $botOwnerIds = this.getBotOwnerIds();
            result = result * 59 + ($botOwnerIds == null ? 43 : ((Object)$botOwnerIds).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TopicHandler.Args(topicParts=" + Arrays.deepToString(this.getTopicParts()) + ", message=" + this.getMessage() + ", botOwnerIds=" + this.getBotOwnerIds() + ")";
        }
    }
}

