/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.AliasRestrictionUpdateData;
import com.github.twitch4j.pubsub.domain.UserModerationActionData;
import com.github.twitch4j.pubsub.events.AliasRestrictionUpdateEvent;
import com.github.twitch4j.pubsub.events.UserModerationActionEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;

class ChatroomHandler
implements TopicHandler {
    ChatroomHandler() {
    }

    @Override
    public String topicName() {
        return "chatrooms-user-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        String[] topicParts = args.getTopicParts();
        if (topicParts.length <= 1) {
            return null;
        }
        String userId = topicParts[1];
        JsonNode msgData = args.getData();
        switch (args.getType()) {
            case "channel_banned_alias_restriction_update": {
                AliasRestrictionUpdateData aliasData = (AliasRestrictionUpdateData)TypeConvert.convertValue((Object)msgData, AliasRestrictionUpdateData.class);
                return new AliasRestrictionUpdateEvent(userId, aliasData);
            }
            case "user_moderation_action": {
                UserModerationActionData actionData = (UserModerationActionData)TypeConvert.convertValue((Object)msgData, UserModerationActionData.class);
                return new UserModerationActionEvent(userId, actionData);
            }
        }
        return null;
    }
}

