/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.kraken.util;

import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.kraken.domain.KrakenCreatedVideo;
import com.github.twitch4j.kraken.domain.KrakenVideo;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.Generated;
import lombok.NonNull;

@Deprecated
public final class KrakenVideoHelper {
    public static final int MAX_PIECE_LENGTH = 19000000;
    public static final int MIN_PIECE_LENGTH = 0x500000;

    public static CompletableFuture<KrakenVideo> uploadVideo(@NonNull TwitchKraken api, String authToken, String channelId, @NonNull String title, String description, String game, String language, List<String> tags, String viewable, Instant viewableAt, @NonNull InputStream inputStream, int pieceLength, long sleepBetweenRequests) {
        if (api == null) {
            throw new NullPointerException("api is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        int length = Math.max(Math.min(pieceLength, 19000000), 0x500000);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            if (channelId == null || channelId.isEmpty()) {
                return new TwitchIdentityProvider(null, null, null).getAdditionalCredentialInformation(new OAuth2Credential("twitch", authToken)).map(Credential::getUserId).orElse(null);
            }
            return channelId;
        }).thenApplyAsync(cId -> (KrakenCreatedVideo)api.createVideo(authToken, (String)cId, title, description, game, language, tags, viewable, viewableAt).execute())).thenApplyAsync(vid -> {
            try {
                try {
                    int bytesRead;
                    byte[] buffer = new byte[length];
                    int partIndex = 1;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        byte[] videoPart = bytesRead < length ? Arrays.copyOfRange(buffer, 0, bytesRead) : buffer;
                        api.uploadVideoPart(vid.getVideoId(), vid.getUpload().getToken(), partIndex++, videoPart).execute();
                        Thread.sleep(Math.max(sleepBetweenRequests, 0L));
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            return vid;
        })).thenApplyAsync(vid -> {
            api.completeVideoUpload(vid.getVideoId(), vid.getUpload().getToken()).execute();
            return vid.getVideo();
        });
    }

    @Generated
    private KrakenVideoHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

