/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.helix.interceptor.TwitchHelixClientIdInterceptor;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public class TwitchHelixDecoder
extends JacksonDecoder {
    public static final String REMAINING_HEADER = "Ratelimit-Remaining";
    private final TwitchHelixClientIdInterceptor interceptor;

    public TwitchHelixDecoder(ObjectMapper mapper, TwitchHelixClientIdInterceptor interceptor) {
        super(mapper);
        this.interceptor = interceptor;
    }

    public Object decode(Response response, Type type) throws IOException {
        String remaining;
        String token = TwitchHelixDecoder.singleFirst((Collection)response.request().headers().get("Authorization"));
        if (token != null && token.startsWith("Bearer ") && (remaining = TwitchHelixDecoder.singleFirst((Collection)response.headers().get(REMAINING_HEADER))) != null) {
            try {
                this.interceptor.updateRemaining(token.substring("Bearer ".length()), Integer.parseInt(remaining));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.decode(response, type);
    }

    static String singleFirst(Collection<String> collection) {
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.toArray(new String[1])[0];
    }
}

