/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchLastBroadcastQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "bf791e4ef8d446ad1d8aa2546778b5b7281fdd7a4e2281a9183eb24f6af84916";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchLastBroadcast($id: ID, $login: String) {\n  user(id: $id, login: $login) {\n    __typename\n    id\n    lastBroadcast {\n      __typename\n      id\n      startedAt\n      title\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchLastBroadcast";
        }
    };
    private final Variables variables;

    public FetchLastBroadcastQuery(@NotNull Input<String> id, @NotNull Input<String> login) {
        Utils.checkNotNull(id, (Object)"id == null");
        Utils.checkNotNull(login, (Object)"login == null");
        this.variables = new Variables(id, login);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        private final Input<String> id;
        private final Input<String> login;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(Input<String> id, Input<String> login) {
            this.id = id;
            this.login = login;
            if (id.defined) {
                this.valueMap.put("id", id.value);
            }
            if (login.defined) {
                this.valueMap.put("login", login.value);
            }
        }

        public Input<String> id() {
            return this.id;
        }

        public Input<String> login() {
            return this.login;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    if (((Variables)this).id.defined) {
                        writer.writeCustom("id", (ScalarType)CustomType.ID, ((Variables)this).id.value != null ? ((Variables)this).id.value : null);
                    }
                    if (((Variables)this).login.defined) {
                        writer.writeString("login", (String)((Variables)this).login.value);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"user", (String)"user", (Map)new UnmodifiableMapBuilder(2).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"id").build()).put((Object)"login", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"login").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            public Data map(ResponseReader reader) {
                User user = (User)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User>(){

                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        private Input<String> id = Input.absent();
        private Input<String> login = Input.absent();

        Builder() {
        }

        public Builder id(@Nullable String id) {
            this.id = Input.fromNullable((Object)id);
            return this;
        }

        public Builder login(@Nullable String login) {
            this.login = Input.fromNullable((Object)login);
            return this;
        }

        public Builder idInput(@NotNull Input<String> id) {
            this.id = (Input)Utils.checkNotNull(id, (Object)"id == null");
            return this;
        }

        public Builder loginInput(@NotNull Input<String> login) {
            this.login = (Input)Utils.checkNotNull(login, (Object)"login == null");
            return this;
        }

        public FetchLastBroadcastQuery build() {
            return new FetchLastBroadcastQuery(this.id, this.login);
        }
    }

    public static class LastBroadcast {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)true, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forCustomType((String)"startedAt", (String)"startedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final String id;
        @Nullable
        final Object startedAt;
        @Nullable
        final String title;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public LastBroadcast(@NotNull String __typename, @Nullable String id, @Nullable Object startedAt, @Nullable String title) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = id;
            this.startedAt = startedAt;
            this.title = title;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public String id() {
            return this.id;
        }

        @Nullable
        public Object startedAt() {
            return this.startedAt;
        }

        @Nullable
        public String title() {
            return this.title;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], startedAt);
                    writer.writeString($responseFields[3], title);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "LastBroadcast{__typename=" + this.__typename + ", id=" + this.id + ", startedAt=" + this.startedAt + ", title=" + this.title + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LastBroadcast) {
                LastBroadcast that = (LastBroadcast)o;
                return this.__typename.equals(that.__typename) && (this.id == null ? that.id == null : this.id.equals(that.id)) && (this.startedAt == null ? that.startedAt == null : this.startedAt.equals(that.startedAt)) && (this.title == null ? that.title == null : this.title.equals(that.title));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id == null ? 0 : this.id.hashCode();
                h *= 1000003;
                h ^= this.startedAt == null ? 0 : this.startedAt.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.title == null ? 0 : this.title.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<LastBroadcast> {
            public LastBroadcast map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Object startedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                String title = reader.readString($responseFields[3]);
                return new LastBroadcast(__typename, id, startedAt, title);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"lastBroadcast", (String)"lastBroadcast", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @Nullable
        final LastBroadcast lastBroadcast;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @NotNull String id, @Nullable LastBroadcast lastBroadcast) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.lastBroadcast = lastBroadcast;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public LastBroadcast lastBroadcast() {
            return this.lastBroadcast;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeObject($responseFields[2], lastBroadcast != null ? lastBroadcast.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", id=" + this.id + ", lastBroadcast=" + this.lastBroadcast + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && (this.lastBroadcast == null ? that.lastBroadcast == null : this.lastBroadcast.equals(that.lastBroadcast));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.lastBroadcast == null ? 0 : this.lastBroadcast.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final LastBroadcast.Mapper lastBroadcastFieldMapper = new LastBroadcast.Mapper();

            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                LastBroadcast lastBroadcast = (LastBroadcast)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<LastBroadcast>(){

                    public LastBroadcast read(ResponseReader reader) {
                        return lastBroadcastFieldMapper.map(reader);
                    }
                });
                return new User(__typename, id, lastBroadcast);
            }
        }
    }
}

