/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.socket.conduit;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.helix.TwitchHelix;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConduitSpec {
    @Nullable
    private String conduitId;
    private int poolShards;
    @Nullable
    private Integer totalShardCount;
    private int shardOffset;
    @Nullable
    private String clientId;
    @Nullable
    private String clientSecret;
    @Nullable
    private TwitchHelix helix;
    @Nullable
    private OAuth2Credential appAccessToken;
    @Nullable
    private ScheduledThreadPoolExecutor executor;
    @Nullable
    private EventManager eventManager;
    @Nullable
    private ProxyConfig proxyConfig;
    @Nullable
    private Duration socketWelcomeTimeout;

    public void validate() {
        if (this.poolShards <= 0) {
            throw new IllegalArgumentException("Pool must have a positive number of websocket shards");
        }
        if (this.shardOffset < 0) {
            throw new IllegalArgumentException("Invalid shard offset");
        }
        if (this.conduitId == null && this.totalShardCount != null && this.totalShardCount < this.poolShards) {
            throw new IllegalArgumentException("Cannot create more sockets than total shards");
        }
        if (this.appAccessToken == null && (this.clientId == null || this.clientSecret == null) && this.helix == null && this.conduitId == null) {
            throw new IllegalArgumentException("Conduit pool is missing authorization");
        }
        if (this.appAccessToken != null && this.appAccessToken.getUserId() != null && !this.appAccessToken.getUserId().isEmpty()) {
            throw new IllegalArgumentException("Access token must be associated with an app rather than a user");
        }
        if (this.socketWelcomeTimeout != null && (this.socketWelcomeTimeout.isNegative() || this.socketWelcomeTimeout.isZero())) {
            throw new IllegalArgumentException("Socket welcome timeout must be positive");
        }
    }

    @NotNull
    public static ConduitSpec process(@NotNull Consumer<ConduitSpec> spec) {
        ConduitSpec config = new ConduitSpec();
        spec.accept(config);
        config.validate();
        return config;
    }

    @Nullable
    @Generated
    public String conduitId() {
        return this.conduitId;
    }

    @Generated
    public int poolShards() {
        return this.poolShards;
    }

    @Nullable
    @Generated
    public Integer totalShardCount() {
        return this.totalShardCount;
    }

    @Generated
    public int shardOffset() {
        return this.shardOffset;
    }

    @Nullable
    @Generated
    public String clientId() {
        return this.clientId;
    }

    @Nullable
    @Generated
    public String clientSecret() {
        return this.clientSecret;
    }

    @Nullable
    @Generated
    public TwitchHelix helix() {
        return this.helix;
    }

    @Nullable
    @Generated
    public OAuth2Credential appAccessToken() {
        return this.appAccessToken;
    }

    @Nullable
    @Generated
    public ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    @Nullable
    @Generated
    public EventManager eventManager() {
        return this.eventManager;
    }

    @Nullable
    @Generated
    public ProxyConfig proxyConfig() {
        return this.proxyConfig;
    }

    @Nullable
    @Generated
    public Duration socketWelcomeTimeout() {
        return this.socketWelcomeTimeout;
    }

    @Generated
    public ConduitSpec conduitId(@Nullable String conduitId) {
        this.conduitId = conduitId;
        return this;
    }

    @Generated
    public ConduitSpec poolShards(int poolShards) {
        this.poolShards = poolShards;
        return this;
    }

    @Generated
    public ConduitSpec totalShardCount(@Nullable Integer totalShardCount) {
        this.totalShardCount = totalShardCount;
        return this;
    }

    @Generated
    public ConduitSpec shardOffset(int shardOffset) {
        this.shardOffset = shardOffset;
        return this;
    }

    @Generated
    public ConduitSpec clientId(@Nullable String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Generated
    public ConduitSpec clientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Generated
    public ConduitSpec helix(@Nullable TwitchHelix helix) {
        this.helix = helix;
        return this;
    }

    @Generated
    public ConduitSpec appAccessToken(@Nullable OAuth2Credential appAccessToken) {
        this.appAccessToken = appAccessToken;
        return this;
    }

    @Generated
    public ConduitSpec executor(@Nullable ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        return this;
    }

    @Generated
    public ConduitSpec eventManager(@Nullable EventManager eventManager) {
        this.eventManager = eventManager;
        return this;
    }

    @Generated
    public ConduitSpec proxyConfig(@Nullable ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    @Generated
    public ConduitSpec socketWelcomeTimeout(@Nullable Duration socketWelcomeTimeout) {
        this.socketWelcomeTimeout = socketWelcomeTimeout;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConduitSpec)) {
            return false;
        }
        ConduitSpec other = (ConduitSpec)o;
        if (this.poolShards() != other.poolShards()) {
            return false;
        }
        if (this.shardOffset() != other.shardOffset()) {
            return false;
        }
        Integer this$totalShardCount = this.totalShardCount();
        Integer other$totalShardCount = other.totalShardCount();
        if (this$totalShardCount == null ? other$totalShardCount != null : !((Object)this$totalShardCount).equals(other$totalShardCount)) {
            return false;
        }
        String this$conduitId = this.conduitId();
        String other$conduitId = other.conduitId();
        if (this$conduitId == null ? other$conduitId != null : !this$conduitId.equals(other$conduitId)) {
            return false;
        }
        String this$clientId = this.clientId();
        String other$clientId = other.clientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.clientSecret();
        String other$clientSecret = other.clientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        TwitchHelix this$helix = this.helix();
        TwitchHelix other$helix = other.helix();
        if (this$helix == null ? other$helix != null : !this$helix.equals(other$helix)) {
            return false;
        }
        OAuth2Credential this$appAccessToken = this.appAccessToken();
        OAuth2Credential other$appAccessToken = other.appAccessToken();
        if (this$appAccessToken == null ? other$appAccessToken != null : !this$appAccessToken.equals(other$appAccessToken)) {
            return false;
        }
        ScheduledThreadPoolExecutor this$executor = this.executor();
        ScheduledThreadPoolExecutor other$executor = other.executor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        EventManager this$eventManager = this.eventManager();
        EventManager other$eventManager = other.eventManager();
        if (this$eventManager == null ? other$eventManager != null : !this$eventManager.equals(other$eventManager)) {
            return false;
        }
        ProxyConfig this$proxyConfig = this.proxyConfig();
        ProxyConfig other$proxyConfig = other.proxyConfig();
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        Duration this$socketWelcomeTimeout = this.socketWelcomeTimeout();
        Duration other$socketWelcomeTimeout = other.socketWelcomeTimeout();
        return !(this$socketWelcomeTimeout == null ? other$socketWelcomeTimeout != null : !((Object)this$socketWelcomeTimeout).equals(other$socketWelcomeTimeout));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.poolShards();
        result = result * 59 + this.shardOffset();
        Integer $totalShardCount = this.totalShardCount();
        result = result * 59 + ($totalShardCount == null ? 43 : ((Object)$totalShardCount).hashCode());
        String $conduitId = this.conduitId();
        result = result * 59 + ($conduitId == null ? 43 : $conduitId.hashCode());
        String $clientId = this.clientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.clientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        TwitchHelix $helix = this.helix();
        result = result * 59 + ($helix == null ? 43 : $helix.hashCode());
        OAuth2Credential $appAccessToken = this.appAccessToken();
        result = result * 59 + ($appAccessToken == null ? 43 : $appAccessToken.hashCode());
        ScheduledThreadPoolExecutor $executor = this.executor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        EventManager $eventManager = this.eventManager();
        result = result * 59 + ($eventManager == null ? 43 : $eventManager.hashCode());
        ProxyConfig $proxyConfig = this.proxyConfig();
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        Duration $socketWelcomeTimeout = this.socketWelcomeTimeout();
        result = result * 59 + ($socketWelcomeTimeout == null ? 43 : ((Object)$socketWelcomeTimeout).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConduitSpec(conduitId=" + this.conduitId() + ", poolShards=" + this.poolShards() + ", totalShardCount=" + this.totalShardCount() + ", shardOffset=" + this.shardOffset() + ", clientId=" + this.clientId() + ", clientSecret=" + this.clientSecret() + ", helix=" + this.helix() + ", appAccessToken=" + this.appAccessToken() + ", executor=" + this.executor() + ", eventManager=" + this.eventManager() + ", proxyConfig=" + this.proxyConfig() + ", socketWelcomeTimeout=" + this.socketWelcomeTimeout() + ")";
    }

    @Generated
    private ConduitSpec() {
    }
}

