/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.socket;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.common.pool.SubscriptionConnectionPool;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.eventsub.EventSubSubscription;
import com.github.twitch4j.eventsub.socket.IEventSubSocket;
import com.github.twitch4j.eventsub.socket.SubscriptionWrapper;
import com.github.twitch4j.eventsub.socket.TwitchSingleUserEventSocketPool;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwitchEventSocketPool
implements IEventSubSocket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchEventSocketPool.class);
    @Generated
    private final Object $lock = new Object[0];
    private final String threadPrefix = "twitch4j-multi-pool-" + CryptoUtils.generateNonce((int)4) + "-eventsub-ws-";
    private final EventManager eventManager;
    @Nullable
    private final ScheduledThreadPoolExecutor executor;
    @NotNull
    private final TwitchIdentityProvider identityProvider;
    @Nullable
    private final OAuth2Credential fallbackToken;
    @NotNull
    private final String baseUrl;
    @Nullable
    private TwitchHelix helix;
    private int maxSubscriptionsPerUser;
    private final UnaryOperator<TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder<?, ?>> advancedConfiguration;
    private final Map<String, TwitchSingleUserEventSocketPool> poolByUserId = new ConcurrentHashMap<String, TwitchSingleUserEventSocketPool>();
    private final Map<SubscriptionWrapper, TwitchSingleUserEventSocketPool> poolBySub = new ConcurrentHashMap<SubscriptionWrapper, TwitchSingleUserEventSocketPool>();

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        this.poolByUserId.values().forEach(IEventSubSocket::disconnect);
    }

    @Override
    public void reconnect() {
        this.poolByUserId.values().forEach(IEventSubSocket::reconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(OAuth2Credential credential, EventSubSubscription sub) {
        Object object = this.$lock;
        synchronized (object) {
            OAuth2Credential token;
            OAuth2Credential oAuth2Credential = token = credential != null ? credential : this.getDefaultToken();
            if (token == null) {
                return false;
            }
            String userId = this.getUserId(token);
            if (userId == null) {
                return false;
            }
            SubscriptionWrapper wrapped = SubscriptionWrapper.wrap(sub);
            if (this.poolBySub.containsKey((Object)wrapped)) {
                return false;
            }
            TwitchSingleUserEventSocketPool pool = this.poolByUserId.computeIfAbsent(userId, id -> ((TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder)((Object)((Object)this.advancedConfiguration.apply((TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder)((TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder)((TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder)((Object)((Object)TwitchSingleUserEventSocketPool.builder().baseUrl(this.baseUrl)))).defaultToken(token).eventManager(this.eventManager)).helix(this.helix).executor(() -> this.executor))))).build());
            if (pool.numSubscriptions() >= this.maxSubscriptionsPerUser) {
                log.debug("Skipping eventsocket subscription registration because pool is already at capacity for user {}: {}", (Object)userId, (Object)sub);
                return false;
            }
            return pool.register(token, sub) && this.poolBySub.put(wrapped, pool) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(EventSubSubscription sub) {
        Object object = this.$lock;
        synchronized (object) {
            SubscriptionWrapper wrapped = SubscriptionWrapper.wrap(sub);
            TwitchSingleUserEventSocketPool pool = this.poolBySub.get((Object)wrapped);
            if (pool == null) {
                return false;
            }
            Boolean unsubscribe = (Boolean)pool.unsubscribe((Object)wrapped);
            if (pool.numSubscriptions() <= 0) {
                this.poolByUserId.entrySet().stream().filter(e -> e.getValue() == pool).map(Map.Entry::getKey).findAny().ifPresent(userId -> {
                    AtomicBoolean close = new AtomicBoolean();
                    this.poolByUserId.computeIfPresent((String)userId, (k, v) -> {
                        if (v.numSubscriptions() <= 0) {
                            close.set(true);
                            return null;
                        }
                        return v;
                    });
                    if (close.get()) {
                        pool.close();
                    }
                });
            }
            return unsubscribe != null && unsubscribe != false && this.poolBySub.remove((Object)wrapped) != null;
        }
    }

    @Override
    public Collection<EventSubSubscription> getSubscriptions() {
        return Collections.unmodifiableSet(this.poolBySub.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            this.poolBySub.clear();
            LinkedList pools = new LinkedList();
            this.poolByUserId.values().removeIf(pools::add);
            pools.forEach(SubscriptionConnectionPool::close);
        }
    }

    @Override
    @Nullable
    public OAuth2Credential getDefaultToken() {
        return this.poolByUserId.values().stream().filter(pool -> pool.getDefaultToken() != null).min(Comparator.comparingInt(SubscriptionConnectionPool::numSubscriptions)).map(IEventSubSocket::getDefaultToken).orElse(this.fallbackToken);
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchSingleUserEventSocketPool pool : this.poolByUserId.values()) {
            int n = pool.numConnections();
            long latency = pool.getLatency();
            if (latency < 0L) continue;
            sum += latency * (long)n;
            count += n;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    public int numConnections() {
        int n = 0;
        for (TwitchSingleUserEventSocketPool pool : this.poolByUserId.values()) {
            n += pool.numConnections();
        }
        return n;
    }

    public int numSubscriptions() {
        return this.getSubscriptions().size();
    }

    @Nullable
    private String getUserId(OAuth2Credential token) {
        if (StringUtils.isNotEmpty((CharSequence)token.getUserId())) {
            return token.getUserId();
        }
        this.identityProvider.getAdditionalCredentialInformation(token).ifPresent(arg_0 -> ((OAuth2Credential)token).updateCredential(arg_0));
        return token.getUserId();
    }

    @Generated
    private static EventManager $default$eventManager() {
        return EventManagerUtils.initializeEventManager(SimpleEventHandler.class);
    }

    @Generated
    private static TwitchIdentityProvider $default$identityProvider() {
        return new TwitchIdentityProvider(null, null, null);
    }

    @Generated
    private static String $default$baseUrl() {
        return "wss://eventsub.wss.twitch.tv/ws";
    }

    @Generated
    private static TwitchHelix $default$helix() {
        return TwitchHelixBuilder.builder().build();
    }

    @Generated
    private static int $default$maxSubscriptionsPerUser() {
        return 900;
    }

    @Generated
    private static UnaryOperator<TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder<?, ?>> $default$advancedConfiguration() {
        return b -> b;
    }

    @Generated
    TwitchEventSocketPool(EventManager eventManager, @Nullable ScheduledThreadPoolExecutor executor, @NotNull TwitchIdentityProvider identityProvider, @Nullable OAuth2Credential fallbackToken, @NotNull String baseUrl, @Nullable TwitchHelix helix, int maxSubscriptionsPerUser, UnaryOperator<TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder<?, ?>> advancedConfiguration) {
        if (identityProvider == null) {
            throw new NullPointerException("identityProvider is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.executor = executor;
        this.identityProvider = identityProvider;
        this.fallbackToken = fallbackToken;
        this.baseUrl = baseUrl;
        this.helix = helix;
        this.maxSubscriptionsPerUser = maxSubscriptionsPerUser;
        this.advancedConfiguration = advancedConfiguration;
    }

    @Generated
    public static TwitchEventSocketPoolBuilder builder() {
        return new TwitchEventSocketPoolBuilder();
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public static class TwitchEventSocketPoolBuilder {
        @Generated
        private boolean eventManager$set;
        @Generated
        private EventManager eventManager$value;
        @Generated
        private ScheduledThreadPoolExecutor executor;
        @Generated
        private boolean identityProvider$set;
        @Generated
        private TwitchIdentityProvider identityProvider$value;
        @Generated
        private OAuth2Credential fallbackToken;
        @Generated
        private boolean baseUrl$set;
        @Generated
        private String baseUrl$value;
        @Generated
        private boolean helix$set;
        @Generated
        private TwitchHelix helix$value;
        @Generated
        private boolean maxSubscriptionsPerUser$set;
        @Generated
        private int maxSubscriptionsPerUser$value;
        @Generated
        private boolean advancedConfiguration$set;
        @Generated
        private UnaryOperator<TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder<?, ?>> advancedConfiguration$value;

        @Generated
        TwitchEventSocketPoolBuilder() {
        }

        @Generated
        public TwitchEventSocketPoolBuilder eventManager(EventManager eventManager) {
            this.eventManager$value = eventManager;
            this.eventManager$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder executor(@Nullable ScheduledThreadPoolExecutor executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder identityProvider(@NotNull TwitchIdentityProvider identityProvider) {
            if (identityProvider == null) {
                throw new NullPointerException("identityProvider is marked non-null but is null");
            }
            this.identityProvider$value = identityProvider;
            this.identityProvider$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder fallbackToken(@Nullable OAuth2Credential fallbackToken) {
            this.fallbackToken = fallbackToken;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder baseUrl(@NotNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl$value = baseUrl;
            this.baseUrl$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder helix(@Nullable TwitchHelix helix) {
            this.helix$value = helix;
            this.helix$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder maxSubscriptionsPerUser(int maxSubscriptionsPerUser) {
            this.maxSubscriptionsPerUser$value = maxSubscriptionsPerUser;
            this.maxSubscriptionsPerUser$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPoolBuilder advancedConfiguration(UnaryOperator<TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder<?, ?>> advancedConfiguration) {
            this.advancedConfiguration$value = advancedConfiguration;
            this.advancedConfiguration$set = true;
            return this;
        }

        @Generated
        public TwitchEventSocketPool build() {
            EventManager eventManager$value = this.eventManager$value;
            if (!this.eventManager$set) {
                eventManager$value = TwitchEventSocketPool.$default$eventManager();
            }
            TwitchIdentityProvider identityProvider$value = this.identityProvider$value;
            if (!this.identityProvider$set) {
                identityProvider$value = TwitchEventSocketPool.$default$identityProvider();
            }
            String baseUrl$value = this.baseUrl$value;
            if (!this.baseUrl$set) {
                baseUrl$value = TwitchEventSocketPool.$default$baseUrl();
            }
            TwitchHelix helix$value = this.helix$value;
            if (!this.helix$set) {
                helix$value = TwitchEventSocketPool.$default$helix();
            }
            int maxSubscriptionsPerUser$value = this.maxSubscriptionsPerUser$value;
            if (!this.maxSubscriptionsPerUser$set) {
                maxSubscriptionsPerUser$value = TwitchEventSocketPool.$default$maxSubscriptionsPerUser();
            }
            UnaryOperator advancedConfiguration$value = this.advancedConfiguration$value;
            if (!this.advancedConfiguration$set) {
                advancedConfiguration$value = TwitchEventSocketPool.$default$advancedConfiguration();
            }
            return new TwitchEventSocketPool(eventManager$value, this.executor, identityProvider$value, this.fallbackToken, baseUrl$value, helix$value, maxSubscriptionsPerUser$value, advancedConfiguration$value);
        }

        @Generated
        public String toString() {
            return "TwitchEventSocketPool.TwitchEventSocketPoolBuilder(eventManager$value=" + this.eventManager$value + ", executor=" + this.executor + ", identityProvider$value=" + this.identityProvider$value + ", fallbackToken=" + this.fallbackToken + ", baseUrl$value=" + this.baseUrl$value + ", helix$value=" + this.helix$value + ", maxSubscriptionsPerUser$value=" + this.maxSubscriptionsPerUser$value + ", advancedConfiguration$value=" + this.advancedConfiguration$value + ")";
        }
    }
}

