/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.subscriptions;

import com.github.twitch4j.eventsub.subscriptions.AutomodMessageHoldType;
import com.github.twitch4j.eventsub.subscriptions.AutomodMessageUpdateType;
import com.github.twitch4j.eventsub.subscriptions.AutomodSettingsUpdateType;
import com.github.twitch4j.eventsub.subscriptions.AutomodTermsUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelAdBreakBeginType;
import com.github.twitch4j.eventsub.subscriptions.ChannelBanType;
import com.github.twitch4j.eventsub.subscriptions.ChannelCharityDonateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelChatClearType;
import com.github.twitch4j.eventsub.subscriptions.ChannelChatMessageType;
import com.github.twitch4j.eventsub.subscriptions.ChannelChatNotificationType;
import com.github.twitch4j.eventsub.subscriptions.ChannelChatSettingsUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelCheerType;
import com.github.twitch4j.eventsub.subscriptions.ChannelClearUserMessagesType;
import com.github.twitch4j.eventsub.subscriptions.ChannelFollowType;
import com.github.twitch4j.eventsub.subscriptions.ChannelFollowTypeV2;
import com.github.twitch4j.eventsub.subscriptions.ChannelGoalBeginType;
import com.github.twitch4j.eventsub.subscriptions.ChannelGoalEndType;
import com.github.twitch4j.eventsub.subscriptions.ChannelGoalProgressType;
import com.github.twitch4j.eventsub.subscriptions.ChannelMessageDeleteType;
import com.github.twitch4j.eventsub.subscriptions.ChannelModerateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelModeratorAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelModeratorRemoveType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsAutomaticRewardRedemptionAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRedemptionAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRedemptionUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRemoveType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelRaidType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscribeType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionEndType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionGiftType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionMessageType;
import com.github.twitch4j.eventsub.subscriptions.ChannelUnbanType;
import com.github.twitch4j.eventsub.subscriptions.ChannelUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelUpdateV2Type;
import com.github.twitch4j.eventsub.subscriptions.ChannelVipAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelVipRemoveType;
import com.github.twitch4j.eventsub.subscriptions.ChannelWarningAcknowledgeType;
import com.github.twitch4j.eventsub.subscriptions.ChannelWarningSendType;
import com.github.twitch4j.eventsub.subscriptions.CharityCampaignProgressType;
import com.github.twitch4j.eventsub.subscriptions.CharityCampaignStartType;
import com.github.twitch4j.eventsub.subscriptions.CharityCampaignStopType;
import com.github.twitch4j.eventsub.subscriptions.ConduitShardDisabledType;
import com.github.twitch4j.eventsub.subscriptions.DropEntitlementGrantType;
import com.github.twitch4j.eventsub.subscriptions.ExtensionBitsTransactionCreateType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainBeginType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainEndType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainProgressType;
import com.github.twitch4j.eventsub.subscriptions.PollBeginType;
import com.github.twitch4j.eventsub.subscriptions.PollEndType;
import com.github.twitch4j.eventsub.subscriptions.PollProgressType;
import com.github.twitch4j.eventsub.subscriptions.PredictionBeginType;
import com.github.twitch4j.eventsub.subscriptions.PredictionEndType;
import com.github.twitch4j.eventsub.subscriptions.PredictionLockType;
import com.github.twitch4j.eventsub.subscriptions.PredictionProgressType;
import com.github.twitch4j.eventsub.subscriptions.ShieldModeBeginType;
import com.github.twitch4j.eventsub.subscriptions.ShieldModeEndType;
import com.github.twitch4j.eventsub.subscriptions.ShoutoutCreateType;
import com.github.twitch4j.eventsub.subscriptions.ShoutoutReceiveType;
import com.github.twitch4j.eventsub.subscriptions.StreamOfflineType;
import com.github.twitch4j.eventsub.subscriptions.StreamOnlineType;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import com.github.twitch4j.eventsub.subscriptions.SuspiciousUserMessageType;
import com.github.twitch4j.eventsub.subscriptions.SuspiciousUserUpdateType;
import com.github.twitch4j.eventsub.subscriptions.UnbanRequestCreateType;
import com.github.twitch4j.eventsub.subscriptions.UnbanRequestResolveType;
import com.github.twitch4j.eventsub.subscriptions.UserAuthorizationGrantType;
import com.github.twitch4j.eventsub.subscriptions.UserAuthorizationRevokeType;
import com.github.twitch4j.eventsub.subscriptions.UserMessageHoldType;
import com.github.twitch4j.eventsub.subscriptions.UserMessageUpdateType;
import com.github.twitch4j.eventsub.subscriptions.UserUpdateType;
import com.github.twitch4j.eventsub.subscriptions.WhisperReceivedType;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class SubscriptionTypes {
    private static final Map<String, SubscriptionType<?, ?, ?>> SUBSCRIPTION_TYPES;
    public static final AutomodMessageHoldType AUTOMOD_MESSAGE_HOLD;
    public static final AutomodMessageUpdateType AUTOMOD_MESSAGE_UPDATE;
    public static final AutomodSettingsUpdateType AUTOMOD_SETTINGS_UPDATE;
    public static final AutomodTermsUpdateType AUTOMOD_TERMS_UPDATE;
    public static final ChannelAdBreakBeginType CHANNEL_AD_BREAK_BEGIN;
    public static final ChannelBanType CHANNEL_BAN;
    public static final ChannelChatClearType CHANNEL_CHAT_CLEAR;
    public static final ChannelClearUserMessagesType CHANNEL_CLEAR_USER_MESSAGES;
    public static final ChannelChatMessageType CHANNEL_CHAT_MESSAGE;
    public static final ChannelMessageDeleteType CHANNEL_CHAT_MESSAGE_DELETE;
    public static final ChannelChatNotificationType CHANNEL_CHAT_NOTIFICATION;
    public static final ChannelChatSettingsUpdateType CHANNEL_CHAT_SETTINGS_UPDATE;
    public static final ChannelCharityDonateType CHANNEL_CHARITY_DONATE;
    public static final CharityCampaignStartType CHANNEL_CHARITY_START;
    public static final CharityCampaignProgressType CHANNEL_CHARITY_PROGRESS;
    public static final CharityCampaignStopType CHANNEL_CHARITY_STOP;
    public static final ChannelCheerType CHANNEL_CHEER;
    @Deprecated
    public static final ChannelFollowType CHANNEL_FOLLOW;
    public static final ChannelFollowTypeV2 CHANNEL_FOLLOW_V2;
    public static final ChannelGoalBeginType CHANNEL_GOAL_BEGIN;
    public static final ChannelGoalProgressType CHANNEL_GOAL_PROGRESS;
    public static final ChannelGoalEndType CHANNEL_GOAL_END;
    public static final ChannelModerateType CHANNEL_MODERATE;
    public static final ChannelModeratorAddType CHANNEL_MODERATOR_ADD;
    public static final ChannelModeratorRemoveType CHANNEL_MODERATOR_REMOVE;
    public static final ChannelPointsAutomaticRewardRedemptionAddType CHANNEL_POINTS_AUTOMATIC_REWARD_REDEMPTION_ADD;
    public static final ChannelPointsCustomRewardAddType CHANNEL_POINTS_CUSTOM_REWARD_ADD;
    public static final ChannelPointsCustomRewardRedemptionAddType CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD;
    public static final ChannelPointsCustomRewardRedemptionUpdateType CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE;
    public static final ChannelPointsCustomRewardRemoveType CHANNEL_POINTS_CUSTOM_REWARD_REMOVE;
    public static final ChannelPointsCustomRewardUpdateType CHANNEL_POINTS_CUSTOM_REWARD_UPDATE;
    public static final ChannelRaidType CHANNEL_RAID;
    public static final ChannelSubscribeType CHANNEL_SUBSCRIBE;
    public static final ChannelSubscriptionEndType CHANNEL_SUBSCRIPTION_END;
    public static final ChannelSubscriptionGiftType CHANNEL_SUBSCRIPTION_GIFT;
    public static final ChannelSubscriptionMessageType CHANNEL_SUBSCRIPTION_MESSAGE;
    public static final SuspiciousUserMessageType CHANNEL_SUSPICIOUS_USER_MESSAGE;
    public static final SuspiciousUserUpdateType CHANNEL_SUSPICIOUS_USER_UPDATE;
    public static final ChannelUnbanType CHANNEL_UNBAN;
    @Deprecated
    public static final ChannelUpdateType CHANNEL_UPDATE;
    public static final ChannelUpdateV2Type CHANNEL_UPDATE_V2;
    public static final ChannelVipAddType CHANNEL_VIP_ADD;
    public static final ChannelVipRemoveType CHANNEL_VIP_REMOVE;
    public static final ChannelWarningAcknowledgeType CHANNEL_WARNING_ACKNOWLEDGE;
    public static final ChannelWarningSendType CHANNEL_WARNING_SEND;
    public static final ConduitShardDisabledType CONDUIT_SHARD_DISABLED;
    public static final DropEntitlementGrantType DROP_ENTITLEMENT_GRANT;
    public static final ExtensionBitsTransactionCreateType EXTENSION_BITS_TRANSACTION_CREATE;
    public static final HypeTrainBeginType HYPE_TRAIN_BEGIN;
    public static final HypeTrainEndType HYPE_TRAIN_END;
    public static final HypeTrainProgressType HYPE_TRAIN_PROGRESS;
    public static final PollBeginType POLL_BEGIN;
    public static final PollProgressType POLL_PROGRESS;
    public static final PollEndType POLL_END;
    public static final PredictionBeginType PREDICTION_BEGIN;
    public static final PredictionProgressType PREDICTION_PROGRESS;
    public static final PredictionLockType PREDICTION_LOCK;
    public static final PredictionEndType PREDICTION_END;
    public static final ShieldModeBeginType SHIELD_MODE_BEGIN_TYPE;
    public static final ShieldModeEndType SHIELD_MODE_END_TYPE;
    public static final ShoutoutCreateType SHOUTOUT_CREATE_TYPE;
    public static final ShoutoutReceiveType SHOUTOUT_RECEIVE_TYPE;
    public static final StreamOfflineType STREAM_OFFLINE;
    public static final StreamOnlineType STREAM_ONLINE;
    public static final UserMessageHoldType USER_MESSAGE_HOLD;
    public static final UserMessageUpdateType USER_MESSAGE_UPDATE;
    public static final UnbanRequestCreateType UNBAN_REQUEST_CREATE;
    public static final UnbanRequestResolveType UNBAN_REQUEST_RESOLVE;
    public static final UserAuthorizationGrantType USER_AUTHORIZATION_GRANT;
    public static final UserAuthorizationRevokeType USER_AUTHORIZATION_REVOKE;
    public static final UserUpdateType USER_UPDATE;
    public static final WhisperReceivedType WHISPER_RECEIVE;

    public static SubscriptionType<?, ?, ?> getSubscriptionType(String subTypeName, String subTypeVersion) {
        return SUBSCRIPTION_TYPES.get(subTypeName + ':' + subTypeVersion);
    }

    @Generated
    private SubscriptionTypes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SubscriptionType[] subscriptionTypeArray = new SubscriptionType[72];
        AUTOMOD_MESSAGE_HOLD = new AutomodMessageHoldType();
        subscriptionTypeArray[0] = AUTOMOD_MESSAGE_HOLD;
        AUTOMOD_MESSAGE_UPDATE = new AutomodMessageUpdateType();
        subscriptionTypeArray[1] = AUTOMOD_MESSAGE_UPDATE;
        AUTOMOD_SETTINGS_UPDATE = new AutomodSettingsUpdateType();
        subscriptionTypeArray[2] = AUTOMOD_SETTINGS_UPDATE;
        AUTOMOD_TERMS_UPDATE = new AutomodTermsUpdateType();
        subscriptionTypeArray[3] = AUTOMOD_TERMS_UPDATE;
        CHANNEL_AD_BREAK_BEGIN = new ChannelAdBreakBeginType();
        subscriptionTypeArray[4] = CHANNEL_AD_BREAK_BEGIN;
        CHANNEL_BAN = new ChannelBanType();
        subscriptionTypeArray[5] = CHANNEL_BAN;
        CHANNEL_CHAT_CLEAR = new ChannelChatClearType();
        subscriptionTypeArray[6] = CHANNEL_CHAT_CLEAR;
        CHANNEL_CLEAR_USER_MESSAGES = new ChannelClearUserMessagesType();
        subscriptionTypeArray[7] = CHANNEL_CLEAR_USER_MESSAGES;
        CHANNEL_CHAT_MESSAGE = new ChannelChatMessageType();
        subscriptionTypeArray[8] = CHANNEL_CHAT_MESSAGE;
        CHANNEL_CHAT_MESSAGE_DELETE = new ChannelMessageDeleteType();
        subscriptionTypeArray[9] = CHANNEL_CHAT_MESSAGE_DELETE;
        CHANNEL_CHAT_NOTIFICATION = new ChannelChatNotificationType();
        subscriptionTypeArray[10] = CHANNEL_CHAT_NOTIFICATION;
        CHANNEL_CHAT_SETTINGS_UPDATE = new ChannelChatSettingsUpdateType();
        subscriptionTypeArray[11] = CHANNEL_CHAT_SETTINGS_UPDATE;
        CHANNEL_CHARITY_DONATE = new ChannelCharityDonateType();
        subscriptionTypeArray[12] = CHANNEL_CHARITY_DONATE;
        CHANNEL_CHARITY_START = new CharityCampaignStartType();
        subscriptionTypeArray[13] = CHANNEL_CHARITY_START;
        CHANNEL_CHARITY_PROGRESS = new CharityCampaignProgressType();
        subscriptionTypeArray[14] = CHANNEL_CHARITY_PROGRESS;
        CHANNEL_CHARITY_STOP = new CharityCampaignStopType();
        subscriptionTypeArray[15] = CHANNEL_CHARITY_STOP;
        CHANNEL_CHEER = new ChannelCheerType();
        subscriptionTypeArray[16] = CHANNEL_CHEER;
        CHANNEL_FOLLOW = new ChannelFollowType();
        subscriptionTypeArray[17] = CHANNEL_FOLLOW;
        CHANNEL_FOLLOW_V2 = new ChannelFollowTypeV2();
        subscriptionTypeArray[18] = CHANNEL_FOLLOW_V2;
        CHANNEL_GOAL_BEGIN = new ChannelGoalBeginType();
        subscriptionTypeArray[19] = CHANNEL_GOAL_BEGIN;
        CHANNEL_GOAL_PROGRESS = new ChannelGoalProgressType();
        subscriptionTypeArray[20] = CHANNEL_GOAL_PROGRESS;
        CHANNEL_GOAL_END = new ChannelGoalEndType();
        subscriptionTypeArray[21] = CHANNEL_GOAL_END;
        CHANNEL_MODERATE = new ChannelModerateType();
        subscriptionTypeArray[22] = CHANNEL_MODERATE;
        CHANNEL_MODERATOR_ADD = new ChannelModeratorAddType();
        subscriptionTypeArray[23] = CHANNEL_MODERATOR_ADD;
        CHANNEL_MODERATOR_REMOVE = new ChannelModeratorRemoveType();
        subscriptionTypeArray[24] = CHANNEL_MODERATOR_REMOVE;
        CHANNEL_POINTS_AUTOMATIC_REWARD_REDEMPTION_ADD = new ChannelPointsAutomaticRewardRedemptionAddType();
        subscriptionTypeArray[25] = CHANNEL_POINTS_AUTOMATIC_REWARD_REDEMPTION_ADD;
        CHANNEL_POINTS_CUSTOM_REWARD_ADD = new ChannelPointsCustomRewardAddType();
        subscriptionTypeArray[26] = CHANNEL_POINTS_CUSTOM_REWARD_ADD;
        CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD = new ChannelPointsCustomRewardRedemptionAddType();
        subscriptionTypeArray[27] = CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD;
        CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE = new ChannelPointsCustomRewardRedemptionUpdateType();
        subscriptionTypeArray[28] = CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE;
        CHANNEL_POINTS_CUSTOM_REWARD_REMOVE = new ChannelPointsCustomRewardRemoveType();
        subscriptionTypeArray[29] = CHANNEL_POINTS_CUSTOM_REWARD_REMOVE;
        CHANNEL_POINTS_CUSTOM_REWARD_UPDATE = new ChannelPointsCustomRewardUpdateType();
        subscriptionTypeArray[30] = CHANNEL_POINTS_CUSTOM_REWARD_UPDATE;
        CHANNEL_RAID = new ChannelRaidType();
        subscriptionTypeArray[31] = CHANNEL_RAID;
        CHANNEL_SUBSCRIBE = new ChannelSubscribeType();
        subscriptionTypeArray[32] = CHANNEL_SUBSCRIBE;
        CHANNEL_SUBSCRIPTION_END = new ChannelSubscriptionEndType();
        subscriptionTypeArray[33] = CHANNEL_SUBSCRIPTION_END;
        CHANNEL_SUBSCRIPTION_GIFT = new ChannelSubscriptionGiftType();
        subscriptionTypeArray[34] = CHANNEL_SUBSCRIPTION_GIFT;
        CHANNEL_SUBSCRIPTION_MESSAGE = new ChannelSubscriptionMessageType();
        subscriptionTypeArray[35] = CHANNEL_SUBSCRIPTION_MESSAGE;
        CHANNEL_SUSPICIOUS_USER_MESSAGE = new SuspiciousUserMessageType();
        subscriptionTypeArray[36] = CHANNEL_SUSPICIOUS_USER_MESSAGE;
        CHANNEL_SUSPICIOUS_USER_UPDATE = new SuspiciousUserUpdateType();
        subscriptionTypeArray[37] = CHANNEL_SUSPICIOUS_USER_UPDATE;
        CHANNEL_UNBAN = new ChannelUnbanType();
        subscriptionTypeArray[38] = CHANNEL_UNBAN;
        CHANNEL_UPDATE = new ChannelUpdateType();
        subscriptionTypeArray[39] = CHANNEL_UPDATE;
        CHANNEL_UPDATE_V2 = new ChannelUpdateV2Type();
        subscriptionTypeArray[40] = CHANNEL_UPDATE_V2;
        CHANNEL_VIP_ADD = new ChannelVipAddType();
        subscriptionTypeArray[41] = CHANNEL_VIP_ADD;
        CHANNEL_VIP_REMOVE = new ChannelVipRemoveType();
        subscriptionTypeArray[42] = CHANNEL_VIP_REMOVE;
        CHANNEL_WARNING_ACKNOWLEDGE = new ChannelWarningAcknowledgeType();
        subscriptionTypeArray[43] = CHANNEL_WARNING_ACKNOWLEDGE;
        CHANNEL_WARNING_SEND = new ChannelWarningSendType();
        subscriptionTypeArray[44] = CHANNEL_WARNING_SEND;
        CONDUIT_SHARD_DISABLED = new ConduitShardDisabledType();
        subscriptionTypeArray[45] = CONDUIT_SHARD_DISABLED;
        DROP_ENTITLEMENT_GRANT = new DropEntitlementGrantType();
        subscriptionTypeArray[46] = DROP_ENTITLEMENT_GRANT;
        EXTENSION_BITS_TRANSACTION_CREATE = new ExtensionBitsTransactionCreateType();
        subscriptionTypeArray[47] = EXTENSION_BITS_TRANSACTION_CREATE;
        HYPE_TRAIN_BEGIN = new HypeTrainBeginType();
        subscriptionTypeArray[48] = HYPE_TRAIN_BEGIN;
        HYPE_TRAIN_END = new HypeTrainEndType();
        subscriptionTypeArray[49] = HYPE_TRAIN_END;
        HYPE_TRAIN_PROGRESS = new HypeTrainProgressType();
        subscriptionTypeArray[50] = HYPE_TRAIN_PROGRESS;
        POLL_BEGIN = new PollBeginType();
        subscriptionTypeArray[51] = POLL_BEGIN;
        POLL_PROGRESS = new PollProgressType();
        subscriptionTypeArray[52] = POLL_PROGRESS;
        POLL_END = new PollEndType();
        subscriptionTypeArray[53] = POLL_END;
        PREDICTION_BEGIN = new PredictionBeginType();
        subscriptionTypeArray[54] = PREDICTION_BEGIN;
        PREDICTION_PROGRESS = new PredictionProgressType();
        subscriptionTypeArray[55] = PREDICTION_PROGRESS;
        PREDICTION_LOCK = new PredictionLockType();
        subscriptionTypeArray[56] = PREDICTION_LOCK;
        PREDICTION_END = new PredictionEndType();
        subscriptionTypeArray[57] = PREDICTION_END;
        SHIELD_MODE_BEGIN_TYPE = new ShieldModeBeginType();
        subscriptionTypeArray[58] = SHIELD_MODE_BEGIN_TYPE;
        SHIELD_MODE_END_TYPE = new ShieldModeEndType();
        subscriptionTypeArray[59] = SHIELD_MODE_END_TYPE;
        SHOUTOUT_CREATE_TYPE = new ShoutoutCreateType();
        subscriptionTypeArray[60] = SHOUTOUT_CREATE_TYPE;
        SHOUTOUT_RECEIVE_TYPE = new ShoutoutReceiveType();
        subscriptionTypeArray[61] = SHOUTOUT_RECEIVE_TYPE;
        STREAM_OFFLINE = new StreamOfflineType();
        subscriptionTypeArray[62] = STREAM_OFFLINE;
        STREAM_ONLINE = new StreamOnlineType();
        subscriptionTypeArray[63] = STREAM_ONLINE;
        USER_MESSAGE_HOLD = new UserMessageHoldType();
        subscriptionTypeArray[64] = USER_MESSAGE_HOLD;
        USER_MESSAGE_UPDATE = new UserMessageUpdateType();
        subscriptionTypeArray[65] = USER_MESSAGE_UPDATE;
        UNBAN_REQUEST_CREATE = new UnbanRequestCreateType();
        subscriptionTypeArray[66] = UNBAN_REQUEST_CREATE;
        UNBAN_REQUEST_RESOLVE = new UnbanRequestResolveType();
        subscriptionTypeArray[67] = UNBAN_REQUEST_RESOLVE;
        USER_AUTHORIZATION_GRANT = new UserAuthorizationGrantType();
        subscriptionTypeArray[68] = USER_AUTHORIZATION_GRANT;
        USER_AUTHORIZATION_REVOKE = new UserAuthorizationRevokeType();
        subscriptionTypeArray[69] = USER_AUTHORIZATION_REVOKE;
        USER_UPDATE = new UserUpdateType();
        subscriptionTypeArray[70] = USER_UPDATE;
        WHISPER_RECEIVE = new WhisperReceivedType();
        subscriptionTypeArray[71] = WHISPER_RECEIVE;
        SUBSCRIPTION_TYPES = Collections.unmodifiableMap(Stream.of(subscriptionTypeArray).collect(Collectors.toMap(type -> type.getName() + ':' + type.getVersion(), Function.identity())));
    }
}

