/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class TypeConvert {
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).propertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE)).addModule((Module)new JavaTimeModule())).build();

    public static String objectToJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T jsonToObject(String json, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(json, valueType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        try {
            return (T)objectMapper.convertValue(fromValue, toValueTypeRef);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)objectMapper.convertValue(fromValue, toValueType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }
}

