/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.enums.TwitchLimitType;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public enum TwitchLimitRegistry {
    INSTANCE;

    private final Map<String, Map<TwitchLimitType, Bucket>> limits = new ConcurrentHashMap<String, Map<TwitchLimitType, Bucket>>();

    public void setLimit(@NonNull String userId, @NonNull TwitchLimitType limitType, @NonNull List<Bandwidth> limit) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        this.getBucketsByUser(userId).compute(limitType, (l, bucket) -> {
            if (bucket != null) {
                bucket.replaceConfiguration(new BucketConfiguration(limit), TokensInheritanceStrategy.AS_IS);
                return bucket;
            }
            return TwitchLimitRegistry.constructBucket(limit);
        });
    }

    @NonNull
    public Optional<Bucket> getBucket(@NonNull String userId, @NonNull TwitchLimitType limitType) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        return Optional.ofNullable(this.limits.get(userId)).map(buckets -> (Bucket)buckets.get((Object)limitType));
    }

    public Bucket getOrInitializeBucket(@NonNull String userId, @NonNull TwitchLimitType limitType, @NonNull List<Bandwidth> limit) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.getBucketsByUser(userId).computeIfAbsent(limitType, l -> TwitchLimitRegistry.constructBucket(limit));
    }

    private Map<TwitchLimitType, Bucket> getBucketsByUser(String userId) {
        return this.limits.computeIfAbsent(userId, s -> Collections.synchronizedMap(new EnumMap(TwitchLimitType.class)));
    }

    private static Bucket constructBucket(List<Bandwidth> limits) {
        LocalBucketBuilder builder = Bucket.builder();
        limits.forEach(arg_0 -> ((LocalBucketBuilder)builder).addLimit(arg_0));
        return builder.build();
    }

    public static TwitchLimitRegistry getInstance() {
        return INSTANCE;
    }
}

