/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.util.EscapeUtils;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

public final class ChatReply {
    public static final String REPLY_MSG_ID_TAG_NAME = "reply-parent-msg-id";
    @NonNull
    private final String messageId;
    private final String messageBody;
    private final String userId;
    private final String userLogin;
    private final String displayName;
    private final String threadMessageId;
    private final String threadUserLogin;
    private final String threadUserName;

    @ApiStatus.Internal
    public static ChatReply parse(Map<String, CharSequence> tags) {
        CharSequence msgId;
        if (tags == null || (msgId = tags.get(REPLY_MSG_ID_TAG_NAME)) == null || msgId.length() == 0) {
            return null;
        }
        return new ChatReply(msgId.toString(), EscapeUtils.unescapeTagValue(tags.get("reply-parent-msg-body")), Objects.toString(tags.get("reply-parent-user-id"), null), Objects.toString(tags.get("reply-parent-user-login"), null), EscapeUtils.unescapeTagValue(tags.get("reply-parent-display-name")), Objects.toString(tags.get("reply-thread-parent-msg-id"), null), Objects.toString(tags.get("reply-thread-parent-user-login"), null), EscapeUtils.unescapeTagValue(tags.get("reply-thread-parent-display-name")));
    }

    @Generated
    public ChatReply(@NonNull String messageId, String messageBody, String userId, String userLogin, String displayName, String threadMessageId, String threadUserLogin, String threadUserName) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
        this.messageBody = messageBody;
        this.userId = userId;
        this.userLogin = userLogin;
        this.displayName = displayName;
        this.threadMessageId = threadMessageId;
        this.threadUserLogin = threadUserLogin;
        this.threadUserName = threadUserName;
    }

    @NonNull
    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getMessageBody() {
        return this.messageBody;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserLogin() {
        return this.userLogin;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getThreadMessageId() {
        return this.threadMessageId;
    }

    @Generated
    public String getThreadUserLogin() {
        return this.threadUserLogin;
    }

    @Generated
    public String getThreadUserName() {
        return this.threadUserName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatReply)) {
            return false;
        }
        ChatReply other = (ChatReply)o;
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$messageBody = this.getMessageBody();
        String other$messageBody = other.getMessageBody();
        if (this$messageBody == null ? other$messageBody != null : !this$messageBody.equals(other$messageBody)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userLogin = this.getUserLogin();
        String other$userLogin = other.getUserLogin();
        if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$threadMessageId = this.getThreadMessageId();
        String other$threadMessageId = other.getThreadMessageId();
        if (this$threadMessageId == null ? other$threadMessageId != null : !this$threadMessageId.equals(other$threadMessageId)) {
            return false;
        }
        String this$threadUserLogin = this.getThreadUserLogin();
        String other$threadUserLogin = other.getThreadUserLogin();
        if (this$threadUserLogin == null ? other$threadUserLogin != null : !this$threadUserLogin.equals(other$threadUserLogin)) {
            return false;
        }
        String this$threadUserName = this.getThreadUserName();
        String other$threadUserName = other.getThreadUserName();
        return !(this$threadUserName == null ? other$threadUserName != null : !this$threadUserName.equals(other$threadUserName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $messageBody = this.getMessageBody();
        result = result * 59 + ($messageBody == null ? 43 : $messageBody.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userLogin = this.getUserLogin();
        result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $threadMessageId = this.getThreadMessageId();
        result = result * 59 + ($threadMessageId == null ? 43 : $threadMessageId.hashCode());
        String $threadUserLogin = this.getThreadUserLogin();
        result = result * 59 + ($threadUserLogin == null ? 43 : $threadUserLogin.hashCode());
        String $threadUserName = this.getThreadUserName();
        result = result * 59 + ($threadUserName == null ? 43 : $threadUserName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatReply(messageId=" + this.getMessageId() + ", messageBody=" + this.getMessageBody() + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", displayName=" + this.getDisplayName() + ", threadMessageId=" + this.getThreadMessageId() + ", threadUserLogin=" + this.getThreadUserLogin() + ", threadUserName=" + this.getThreadUserName() + ")";
    }
}

