/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.pool;

import com.github.twitch4j.common.pool.AbstractConnectionPool;
import com.github.twitch4j.common.pool.TransactionalSubscriber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SubscriptionConnectionPool<C, S, T, U>
extends AbstractConnectionPool<C>
implements TransactionalSubscriber<S, T, U> {
    protected final boolean disposeUnusedConnections;
    protected final int maxSubscriptionsPerConnection;
    protected final Set<C> saturatedConnections = ConcurrentHashMap.newKeySet();
    protected final ConcurrentMap<C, Integer> unsaturatedConnections = new ConcurrentHashMap<C, Integer>();
    protected final ConcurrentMap<S, C> subscriptions = new ConcurrentHashMap<S, C>();
    protected final AtomicBoolean closed = new AtomicBoolean();

    @Override
    public T subscribe(S s) {
        if (this.closed.get()) {
            throw new IllegalStateException("Subscription cannot be created after pool was closed!");
        }
        Object prevConnection = this.subscriptions.get(s);
        if (prevConnection != null) {
            return this.handleDuplicateSubscription(null, prevConnection, s);
        }
        int size = this.getSubscriptionSize(s);
        if (size > this.maxSubscriptionsPerConnection) {
            throw new IllegalArgumentException("Subscription is too large for a single connection");
        }
        C connection = this.getOrCreateConnectionWithHeadroomAndIncrement(size);
        if (connection != null && (prevConnection = this.subscriptions.putIfAbsent(s, connection)) != null) {
            T dupeResponse = this.handleDuplicateSubscription(connection, prevConnection, s);
            this.decrementSubscriptions(connection, size);
            return dupeResponse;
        }
        return this.handleSubscription(connection, s);
    }

    @Override
    public U unsubscribe(T t) {
        S request = this.getRequestFromSubscription(t);
        Object connection = this.subscriptions.remove(request);
        U u = this.handleUnsubscription(connection, t);
        if (connection != null && !this.closed.get()) {
            this.decrementSubscriptions(connection, this.getSubscriptionSize(request));
        }
        return u;
    }

    @Override
    public int numConnections() {
        return this.saturatedConnections.size() + this.unsaturatedConnections.size();
    }

    @Override
    protected Iterable<C> getConnections() {
        ArrayList<Object> connections = new ArrayList<Object>(this.numConnections());
        connections.addAll(this.saturatedConnections);
        connections.addAll(this.unsaturatedConnections.keySet());
        return Collections.unmodifiableCollection(connections);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ArrayList drained = new ArrayList(this.numConnections());
            this.saturatedConnections.removeIf(drained::add);
            this.unsaturatedConnections.keySet().removeIf(drained::add);
            drained.forEach(this::disposeConnection);
            this.subscriptions.clear();
        }
    }

    public int numSubscriptions() {
        int n = 0;
        n += this.saturatedConnections.size() * this.maxSubscriptionsPerConnection;
        for (Integer i : this.unsaturatedConnections.values()) {
            n += i.intValue();
        }
        return n;
    }

    protected abstract T handleSubscription(C var1, S var2);

    protected abstract T handleDuplicateSubscription(C var1, C var2, S var3);

    protected abstract U handleUnsubscription(C var1, T var2);

    protected abstract S getRequestFromSubscription(T var1);

    protected abstract int getSubscriptionSize(S var1);

    private C getOrCreateConnectionWithHeadroomAndIncrement(int increment) {
        int max = this.maxSubscriptionsPerConnection;
        AtomicBoolean foundUnsaturated = new AtomicBoolean();
        for (Object connection : this.unsaturatedConnections.keySet()) {
            Integer computed = this.unsaturatedConnections.compute(connection, (c, n) -> {
                if (n == null || n + 1 > max) {
                    return null;
                }
                int n2 = n + increment;
                if (n2 > max) {
                    return n;
                }
                foundUnsaturated.set(true);
                return n2 < max ? Integer.valueOf(n2) : null;
            });
            if (!foundUnsaturated.get()) continue;
            if (computed == null) {
                this.saturatedConnections.add(connection);
            }
            return (C)connection;
        }
        Object c2 = this.createConnection();
        if (c2 != null) {
            if (increment < max) {
                this.unsaturatedConnections.putIfAbsent(c2, increment);
            } else {
                this.saturatedConnections.add(c2);
            }
        }
        return c2;
    }

    private void decrementSubscriptions(C connection, int decrement) {
        Integer newSubs = this.unsaturatedConnections.compute(connection, (c, n) -> {
            int prev;
            if (n != null) {
                prev = n;
            } else {
                prev = this.maxSubscriptionsPerConnection;
                this.saturatedConnections.remove(connection);
            }
            int next = prev - decrement;
            if (next <= 0 && this.disposeUnusedConnections) {
                return null;
            }
            return next;
        });
        if (newSubs == null) {
            this.disposeConnection(connection);
        }
    }

    private static <C, S, T, U> boolean $default$disposeUnusedConnections() {
        return true;
    }

    private static <C, S, T, U> int $default$maxSubscriptionsPerConnection() {
        return 50;
    }

    protected SubscriptionConnectionPool(SubscriptionConnectionPoolBuilder<C, S, T, U, ?, ?> b) {
        super(b);
        this.disposeUnusedConnections = ((SubscriptionConnectionPoolBuilder)b).disposeUnusedConnections$set ? ((SubscriptionConnectionPoolBuilder)b).disposeUnusedConnections$value : SubscriptionConnectionPool.$default$disposeUnusedConnections();
        this.maxSubscriptionsPerConnection = ((SubscriptionConnectionPoolBuilder)b).maxSubscriptionsPerConnection$set ? ((SubscriptionConnectionPoolBuilder)b).maxSubscriptionsPerConnection$value : SubscriptionConnectionPool.$default$maxSubscriptionsPerConnection();
    }

    public static abstract class SubscriptionConnectionPoolBuilder<C, S, T, U, C2 extends SubscriptionConnectionPool<C, S, T, U>, B extends SubscriptionConnectionPoolBuilder<C, S, T, U, C2, B>>
    extends AbstractConnectionPool.AbstractConnectionPoolBuilder<C, C2, B> {
        private boolean disposeUnusedConnections$set;
        private boolean disposeUnusedConnections$value;
        private boolean maxSubscriptionsPerConnection$set;
        private int maxSubscriptionsPerConnection$value;

        public B disposeUnusedConnections(boolean disposeUnusedConnections) {
            this.disposeUnusedConnections$value = disposeUnusedConnections;
            this.disposeUnusedConnections$set = true;
            return (B)this.self();
        }

        public B maxSubscriptionsPerConnection(int maxSubscriptionsPerConnection) {
            this.maxSubscriptionsPerConnection$value = maxSubscriptionsPerConnection;
            this.maxSubscriptionsPerConnection$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C2 build();

        @Override
        public String toString() {
            return "SubscriptionConnectionPool.SubscriptionConnectionPoolBuilder(super=" + super.toString() + ", disposeUnusedConnections$value=" + this.disposeUnusedConnections$value + ", maxSubscriptionsPerConnection$value=" + this.maxSubscriptionsPerConnection$value + ")";
        }
    }
}

