/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.EscapeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class TwitchUtils {
    public static final EventUser ANONYMOUS_GIFTER = new EventUser("274598607", "ananonymousgifter");
    public static final EventUser ANONYMOUS_CHEERER = new EventUser("407665396", "ananonymouscheerer");

    @Deprecated
    public static Set<CommandPermission> getPermissionsFromTags(Map<String, Object> tags) {
        return TwitchUtils.getPermissionsFromTags(tags, new HashMap<String, String>());
    }

    @Deprecated
    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        return TwitchUtils.getPermissionsFromTags(tags, badges, null, null);
    }

    @ApiStatus.Internal
    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges, String userId, Collection<String> botOwnerIds) {
        Object inputBadges;
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        Object subscriber = tags.get("subscriber");
        if (subscriber instanceof CharSequence && !StringUtils.equals((CharSequence)"0", (CharSequence)((CharSequence)subscriber))) {
            badges.put("subscriber", subscriber.toString());
        }
        if ((inputBadges = tags.get("badges")) instanceof CharSequence) {
            return TwitchUtils.getPermissionsFromTags((CharSequence)inputBadges, userId, botOwnerIds, badges);
        }
        if (inputBadges instanceof Collection) {
            Collection list = (Collection)inputBadges;
            for (Object badgeObj : list) {
                Map badge;
                Object badgeId;
                if (!(badgeObj instanceof Map) || !((badgeId = (badge = (Map)badgeObj).get("id")) instanceof String)) continue;
                Object badgeVersion = badge.get("version");
                badges.put((String)badgeId, badgeVersion instanceof String ? (String)badgeVersion : null);
            }
        }
        return TwitchUtils.getPermissionsFromTags(null, userId, botOwnerIds, badges);
    }

    private static Set<CommandPermission> getPermissionsFromTags(@Nullable CharSequence badgesTag, String userId, Collection<String> botOwnerIds, @NonNull Map<String, String> badges) {
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        EnumSet<CommandPermission> permissionSet = EnumSet.of(CommandPermission.EVERYONE);
        if (badgesTag != null) {
            badges.putAll(TwitchUtils.parseBadges(badgesTag.toString()));
        }
        if (!badges.isEmpty()) {
            String hypeBadge;
            if (badges.containsKey("broadcaster")) {
                permissionSet.add(CommandPermission.BROADCASTER);
                permissionSet.add(CommandPermission.MODERATOR);
            }
            if (badges.containsKey("premium") || badges.containsKey("turbo")) {
                permissionSet.add(CommandPermission.PRIME_TURBO);
            }
            if (badges.containsKey("moderator")) {
                permissionSet.add(CommandPermission.MODERATOR);
            }
            if (badges.containsKey("partner") || badges.containsKey("ambassador")) {
                permissionSet.add(CommandPermission.PARTNER);
            }
            if (badges.containsKey("vip")) {
                permissionSet.add(CommandPermission.VIP);
            }
            if (badges.containsKey("turbo")) {
                permissionSet.add(CommandPermission.PRIME_TURBO);
            }
            if (badges.containsKey("staff") || badges.containsKey("admin")) {
                permissionSet.add(CommandPermission.TWITCHSTAFF);
            }
            if (badges.containsKey("subscriber")) {
                permissionSet.add(CommandPermission.SUBSCRIBER);
            }
            if (badges.containsKey("sub-gifter") || badges.containsKey("sub-gift-leader")) {
                permissionSet.add(CommandPermission.SUBGIFTER);
            }
            if (badges.containsKey("bits") || badges.containsKey("bits-leader") || badges.containsKey("anonymous-cheerer")) {
                permissionSet.add(CommandPermission.BITS_CHEERER);
            }
            if (badges.containsKey("founder")) {
                permissionSet.add(CommandPermission.FOUNDER);
            }
            if ("1".equals(hypeBadge = badges.get("hype-train"))) {
                permissionSet.add(CommandPermission.CURRENT_HYPE_TRAIN_CONDUCTOR);
            } else if ("2".equals(hypeBadge)) {
                permissionSet.add(CommandPermission.FORMER_HYPE_TRAIN_CONDUCTOR);
            }
            String predictionBadge = badges.get("predictions");
            if (StringUtils.isNotEmpty((CharSequence)predictionBadge)) {
                char first = predictionBadge.charAt(0);
                if (first == 'b') {
                    permissionSet.add(CommandPermission.PREDICTIONS_BLUE);
                } else if (first == 'p') {
                    permissionSet.add(CommandPermission.PREDICTIONS_PINK);
                }
            }
            if (badges.containsKey("no_audio")) {
                permissionSet.add(CommandPermission.NO_AUDIO);
            }
            if (badges.containsKey("no_video")) {
                permissionSet.add(CommandPermission.NO_VIDEO);
            }
            if (badges.containsKey("moments")) {
                permissionSet.add(CommandPermission.MOMENTS);
            }
            if (badges.containsKey("artist-badge")) {
                permissionSet.add(CommandPermission.ARTIST);
            }
        }
        if (userId != null && botOwnerIds != null && botOwnerIds.contains(userId)) {
            permissionSet.add(CommandPermission.OWNER);
        }
        return permissionSet;
    }

    public static Map<String, String> parseBadges(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return map;
        }
        raw = EscapeUtils.unescapeTagValue(raw);
        for (String tag : raw.split(",")) {
            String[] val = tag.split("/", 2);
            String key = val[0];
            String value = val.length > 1 ? val[1] : null;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }
}

