/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.client.websocket;

import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.github.twitch4j.util.IBackoffStrategy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class WebsocketConnectionConfig {
    private String baseUrl;
    private int wsPingPeriod = 0;
    private int connectionTimeout = 60000;
    private int socketTimeout = 30000;
    private Map<String, String> headers = null;
    private ScheduledExecutorService taskExecutor = new ScheduledThreadPoolExecutor(2);
    private IBackoffStrategy backoffStrategy = ExponentialBackoffStrategy.builder().immediateFirst(false).baseMillis(Duration.ofSeconds(1L).toMillis()).jitter(true).multiplier(2.0).maximumBackoff(Duration.ofMinutes(5L).toMillis()).build();
    private BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged = (oldState, newState) -> {};
    private Runnable onPreConnect = () -> {};
    private Runnable onPostConnect = () -> {};
    private Runnable onConnected = () -> {};
    private Consumer<String> onTextMessage = text -> {};
    private Runnable onDisconnecting = () -> {};
    private Runnable onPreDisconnect = () -> {};
    private Runnable onPostDisconnect = () -> {};
    private ProxyConfig proxyConfig;

    public static WebsocketConnectionConfig process(Consumer<WebsocketConnectionConfig> spec) {
        WebsocketConnectionConfig data = new WebsocketConnectionConfig();
        spec.accept(data);
        data.validate();
        return data;
    }

    public void validate() {
        Objects.requireNonNull(this.baseUrl, "baseUrl may not be null!");
        if (this.wsPingPeriod < 0) {
            throw new RuntimeException("wsPingPeriod must be 0 or greater, set to 0 to disable!");
        }
        if (this.connectionTimeout < 0) {
            throw new RuntimeException("connectionTimeout must be 0 or greater, set to 0 to disable!");
        }
        if (this.socketTimeout < 0) {
            throw new RuntimeException("socketTimeout must be 0 or greater, set to 0 to disable!");
        }
        Objects.requireNonNull(this.taskExecutor, "taskExecutor may not be null!");
        Objects.requireNonNull(this.backoffStrategy, "backoffStrategy may not be null!");
        Objects.requireNonNull(this.onStateChanged, "onStateChanged may not be null!");
        Objects.requireNonNull(this.onPreConnect, "onPreConnect may not be null!");
        Objects.requireNonNull(this.onPostConnect, "onPostConnect may not be null!");
        Objects.requireNonNull(this.onConnected, "onConnected may not be null!");
        Objects.requireNonNull(this.onTextMessage, "onTextMessage may not be null!");
        Objects.requireNonNull(this.onTextMessage, "onTextMessage may not be null!");
        Objects.requireNonNull(this.onDisconnecting, "onDisconnecting may not be null!");
        Objects.requireNonNull(this.onPreDisconnect, "onPreDisconnect may not be null!");
        Objects.requireNonNull(this.onPostDisconnect, "onPostDisconnect may not be null!");
    }

    public WebsocketConnectionConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WebsocketConnectionConfig wsPingPeriod(int wsPingPeriod) {
        this.wsPingPeriod = wsPingPeriod;
        return this;
    }

    public WebsocketConnectionConfig connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public WebsocketConnectionConfig socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public WebsocketConnectionConfig headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public WebsocketConnectionConfig taskExecutor(ScheduledExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    public WebsocketConnectionConfig backoffStrategy(IBackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    public WebsocketConnectionConfig onStateChanged(BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged) {
        this.onStateChanged = onStateChanged;
        return this;
    }

    public WebsocketConnectionConfig onPreConnect(Runnable onPreConnect) {
        this.onPreConnect = onPreConnect;
        return this;
    }

    public WebsocketConnectionConfig onPostConnect(Runnable onPostConnect) {
        this.onPostConnect = onPostConnect;
        return this;
    }

    public WebsocketConnectionConfig onConnected(Runnable onConnected) {
        this.onConnected = onConnected;
        return this;
    }

    public WebsocketConnectionConfig onTextMessage(Consumer<String> onTextMessage) {
        this.onTextMessage = onTextMessage;
        return this;
    }

    public WebsocketConnectionConfig onDisconnecting(Runnable onDisconnecting) {
        this.onDisconnecting = onDisconnecting;
        return this;
    }

    public WebsocketConnectionConfig onPreDisconnect(Runnable onPreDisconnect) {
        this.onPreDisconnect = onPreDisconnect;
        return this;
    }

    public WebsocketConnectionConfig onPostDisconnect(Runnable onPostDisconnect) {
        this.onPostDisconnect = onPostDisconnect;
        return this;
    }

    public WebsocketConnectionConfig proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public int wsPingPeriod() {
        return this.wsPingPeriod;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public ScheduledExecutorService taskExecutor() {
        return this.taskExecutor;
    }

    public IBackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged() {
        return this.onStateChanged;
    }

    public Runnable onPreConnect() {
        return this.onPreConnect;
    }

    public Runnable onPostConnect() {
        return this.onPostConnect;
    }

    public Runnable onConnected() {
        return this.onConnected;
    }

    public Consumer<String> onTextMessage() {
        return this.onTextMessage;
    }

    public Runnable onDisconnecting() {
        return this.onDisconnecting;
    }

    public Runnable onPreDisconnect() {
        return this.onPreDisconnect;
    }

    public Runnable onPostDisconnect() {
        return this.onPostDisconnect;
    }

    public ProxyConfig proxyConfig() {
        return this.proxyConfig;
    }
}

