/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.TwitchEvent;
import com.github.twitch4j.chat.flag.AutoModFlag;
import com.github.twitch4j.chat.flag.FlagParser;
import com.github.twitch4j.chat.util.MessageParser;
import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EscapeUtils;
import com.github.twitch4j.common.util.TwitchUtils;
import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IRCMessageEvent
extends TwitchEvent {
    private static final Pattern CLIENT_PATTERN = Pattern.compile((String)"^:(.*?)!(.*?)@(.*?).tmi.twitch.tv$");
    public static final String NONCE_TAG_NAME = "client-nonce";
    private final Map<String, CharSequence> escapedTags;
    private Map<String, String> badges = null;
    private Map<String, String> badgeInfo = null;
    private final CharSequence clientName;
    private final String commandType;
    private String channelId;
    @Nullable
    private String channelName;
    @Nullable
    private final String message;
    private final CharSequence payload;
    private Set<CommandPermission> clientPermissions = null;
    private final AtomicReference<Object> flags = new AtomicReference();
    private final String rawMessage;
    @Nullable
    private final Collection<String> botOwnerIds;

    @ApiStatus.Internal
    public IRCMessageEvent(@NotNull String rawMessage, @NotNull Map<String, CharSequence> escapedTags, CharSequence clientName, @NotNull String commandType, @Nullable String channelName, @Nullable CharSequence payload, @Nullable String message, @NotNull Map<String, String> channelIdToChannelName, @NotNull Map<String, String> channelNameToChannelId, @Nullable Collection<String> botOwnerIds) {
        super(IRCMessageEvent.getEventId(escapedTags), IRCMessageEvent.getEventTime(escapedTags));
        this.rawMessage = rawMessage;
        this.escapedTags = escapedTags;
        this.clientName = clientName;
        this.commandType = commandType;
        this.channelName = channelName;
        this.payload = payload;
        this.message = message;
        this.botOwnerIds = botOwnerIds;
        if (channelName == null) {
            this.channelId = this.getRawTagString("room-id");
            this.channelName = this.channelId == null ? null : channelIdToChannelName.get(this.channelId);
        } else {
            this.channelId = channelNameToChannelId.get(channelName);
            if (this.channelId == null) {
                this.channelId = this.getRawTagString("room-id");
            }
        }
    }

    @Deprecated
    public IRCMessageEvent(String rawMessage, Map<String, String> channelIdToChannelName, Map<String, String> channelNameToChannelId, Collection<String> botOwnerIds) {
        this(Optional.ofNullable(MessageParser.parse(rawMessage, channelIdToChannelName, channelNameToChannelId, botOwnerIds)).orElse(IRCMessageEvent.failure(rawMessage)), channelIdToChannelName, channelNameToChannelId, botOwnerIds);
    }

    private IRCMessageEvent(@NotNull IRCMessageEvent copy, @NotNull Map<String, String> channelIdToChannelName, @NotNull Map<String, String> channelNameToChannelId, @Nullable Collection<String> botOwnerIds) {
        this(copy.rawMessage, copy.escapedTags, copy.clientName, copy.commandType, copy.channelName, copy.payload, copy.message, channelIdToChannelName, channelNameToChannelId, botOwnerIds);
    }

    private static IRCMessageEvent failure(String raw) {
        return new IRCMessageEvent(raw, Collections.emptyMap(), null, "UNKNOWN", null, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    }

    public Map<String, String> getBadgeInfo() {
        Map<String, String> info = this.badgeInfo;
        if (info != null) {
            return info;
        }
        this.badgeInfo = this.getTagValue("badge-info").map(TwitchUtils::parseBadges).orElse(Collections.emptyMap());
        return this.badgeInfo;
    }

    public Map<String, String> getBadges() {
        Map<String, String> badges = this.badges;
        if (badges == null) {
            this.badges = badges = new HashMap<String, String>();
            this.clientPermissions = TwitchUtils.getPermissionsFromTags(this.getRawTags(), badges, (String)(this.botOwnerIds != null ? this.getUserId() : null), this.botOwnerIds);
        }
        return badges;
    }

    public Set<CommandPermission> getClientPermissions() {
        if (this.clientPermissions == null) {
            this.getBadges();
        }
        return this.clientPermissions;
    }

    @Deprecated
    public Boolean isValid() {
        return !this.getCommandType().equals("UNKNOWN");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static Map<String, CharSequence> parseTags(String raw) {
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return map;
        }
        for (String tag : raw.split(";")) {
            String[] val = tag.split("=", 2);
            String key = val[0];
            String value = val.length > 1 ? val[1] : null;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static Optional<String> parseClientName(String raw) {
        if (raw.equals(":tmi.twitch.tv") || raw.equals(":jtv")) {
            return Optional.empty();
        }
        Matcher matcher = CLIENT_PATTERN.matcher((CharSequence)raw);
        if (matcher.matches()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.ofNullable(raw);
    }

    public String getUserId() {
        return this.getRawTagString("user-id");
    }

    public String getUserName() {
        String login = this.getRawTagString("login");
        if (login != null) {
            return login;
        }
        return this.getClientName().filter(StringUtils::isNotBlank).orElseGet(() -> this.getUserDisplayName().orElse(null));
    }

    public Optional<String> getUserDisplayName() {
        return this.getTagValue("display-name");
    }

    public Optional<String> getUserChatColor() {
        return this.getTagValue("color");
    }

    public String getTargetUserId() {
        return this.getRawTagString("target-user-id");
    }

    public Optional<String> getMessageId() {
        return this.getTagValue("id");
    }

    public Optional<String> getNonce() {
        return this.getTagValue(NONCE_TAG_NAME);
    }

    public OptionalInt getSubscriberMonths() {
        Map<String, String> badgeInfo = this.getBadgeInfo();
        String monthsStr = badgeInfo.getOrDefault("subscriber", badgeInfo.get("founder"));
        if (monthsStr != null) {
            try {
                return OptionalInt.of(Integer.parseInt(monthsStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public OptionalInt getSubscriptionTier() {
        String subscriber = this.getBadges().get("subscriber");
        if (subscriber != null) {
            try {
                return OptionalInt.of(Math.max(Integer.parseInt(subscriber) / 1000, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public OptionalInt getCheererTier() {
        String bits = this.getBadges().get("bits");
        if (bits != null) {
            try {
                return OptionalInt.of(Integer.parseInt(bits));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public OptionalInt getPredictedChoiceIndex() {
        String predictions = this.getBadges().get("predictions");
        if (predictions != null) {
            int delim = predictions.indexOf(45);
            try {
                return OptionalInt.of(Integer.parseInt(predictions.substring(delim + 1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public Optional<String> getPredictedChoiceTitle() {
        return Optional.ofNullable(this.getBadgeInfo().get("predictions")).map(EscapeUtils::unescapeTagValue);
    }

    public Optional<String> getTagValue(String tagName) {
        return Optional.ofNullable(this.getRawTag(tagName)).filter(StringUtils::isNotBlank).map(EscapeUtils::unescapeTagValue);
    }

    public EventUser getUser() {
        if (this.getUserId() != null || this.getUserName() != null) {
            return new EventUser(this.getUserId(), this.getUserName());
        }
        return null;
    }

    public EventUser getTargetUser() {
        return new EventUser(this.getTargetUserId(), this.getCommandType().equalsIgnoreCase("CLEARCHAT") ? this.getMessage().get() : null);
    }

    public EventChannel getChannel() {
        return new EventChannel(this.getChannelId(), this.channelName);
    }

    public Optional<String> getChannelName() {
        return Optional.ofNullable(this.channelName);
    }

    public Optional<String> getPayload() {
        return Optional.ofNullable(this.payload).map(CharSequence::toString);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Optional<String> getClientName() {
        return Optional.ofNullable(this.clientName).filter(client -> !StringUtils.equals((CharSequence)client, (CharSequence)"tmi.twitch.tv")).filter(client -> !StringUtils.equals((CharSequence)client, (CharSequence)"jtv")).map(CharSequence::toString);
    }

    @Nullable
    @ApiStatus.Internal
    public CharSequence getRawTag(@NotNull String name) {
        return this.escapedTags.get(name);
    }

    @Nullable
    @ApiStatus.Internal
    public String getRawTagString(@NotNull String name) {
        return Objects.toString(this.getRawTag(name), null);
    }

    @Deprecated
    public Map<String, String> getTags() {
        HashMap t = new HashMap(this.escapedTags.size() * 4 / 3 + 1);
        this.escapedTags.forEach((k, v) -> t.put(k, Objects.toString(v, null)));
        return Collections.unmodifiableMap(t);
    }

    @Deprecated
    public Map<String, Object> getRawTags() {
        return Collections.unmodifiableMap(this.escapedTags);
    }

    private static String getEventId(Map<String, CharSequence> tags) {
        CharSequence id = tags.get("id");
        return id != null ? id.toString() : CryptoUtils.generateNonce((int)32);
    }

    private static Instant getEventTime(Map<String, CharSequence> tags) {
        CharSequence ts = tags.get("tmi-sent-ts");
        return ts != null ? Instant.ofEpochMilli(Long.parseLong(ts.toString())) : Instant.now();
    }

    @Override
    public String toString() {
        return "IRCMessageEvent(escapedTags=" + this.getEscapedTags() + ", badges=" + this.getBadges() + ", badgeInfo=" + this.getBadgeInfo() + ", clientName=" + this.getClientName() + ", commandType=" + this.getCommandType() + ", channelId=" + this.getChannelId() + ", channelName=" + this.getChannelName() + ", message=" + this.getMessage() + ", payload=" + this.getPayload() + ", clientPermissions=" + this.getClientPermissions() + ", flags=" + this.getFlags() + ", rawMessage=" + this.getRawMessage() + ", botOwnerIds=" + this.botOwnerIds + ")";
    }

    public Map<String, CharSequence> getEscapedTags() {
        return this.escapedTags;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    private void setBadges(Map<String, String> badges) {
        this.badges = badges;
    }

    private void setBadgeInfo(Map<String, String> badgeInfo) {
        this.badgeInfo = badgeInfo;
    }

    private void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    private void setChannelName(@Nullable String channelName) {
        this.channelName = channelName;
    }

    private void setClientPermissions(Set<CommandPermission> clientPermissions) {
        this.clientPermissions = clientPermissions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IRCMessageEvent)) {
            return false;
        }
        IRCMessageEvent other = (IRCMessageEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<String, CharSequence> this$escapedTags = this.getEscapedTags();
        Map<String, CharSequence> other$escapedTags = other.getEscapedTags();
        if (this$escapedTags == null ? other$escapedTags != null : !((Object)this$escapedTags).equals(other$escapedTags)) {
            return false;
        }
        Map<String, String> this$badges = this.getBadges();
        Map<String, String> other$badges = other.getBadges();
        if (this$badges == null ? other$badges != null : !((Object)this$badges).equals(other$badges)) {
            return false;
        }
        Map<String, String> this$badgeInfo = this.getBadgeInfo();
        Map<String, String> other$badgeInfo = other.getBadgeInfo();
        if (this$badgeInfo == null ? other$badgeInfo != null : !((Object)this$badgeInfo).equals(other$badgeInfo)) {
            return false;
        }
        Optional<String> this$clientName = this.getClientName();
        Optional<String> other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !((Object)this$clientName).equals(other$clientName)) {
            return false;
        }
        String this$commandType = this.getCommandType();
        String other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        Optional<String> this$channelName = this.getChannelName();
        Optional<String> other$channelName = other.getChannelName();
        if (this$channelName == null ? other$channelName != null : !((Object)this$channelName).equals(other$channelName)) {
            return false;
        }
        Optional<String> this$message = this.getMessage();
        Optional<String> other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Optional<String> this$payload = this.getPayload();
        Optional<String> other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        Set<CommandPermission> this$clientPermissions = this.getClientPermissions();
        Set<CommandPermission> other$clientPermissions = other.getClientPermissions();
        if (this$clientPermissions == null ? other$clientPermissions != null : !((Object)this$clientPermissions).equals(other$clientPermissions)) {
            return false;
        }
        List<AutoModFlag> this$flags = this.getFlags();
        List<AutoModFlag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$rawMessage = this.getRawMessage();
        String other$rawMessage = other.getRawMessage();
        if (this$rawMessage == null ? other$rawMessage != null : !this$rawMessage.equals(other$rawMessage)) {
            return false;
        }
        Collection<String> this$botOwnerIds = this.botOwnerIds;
        Collection<String> other$botOwnerIds = other.botOwnerIds;
        return !(this$botOwnerIds == null ? other$botOwnerIds != null : !((Object)this$botOwnerIds).equals(other$botOwnerIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IRCMessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, CharSequence> $escapedTags = this.getEscapedTags();
        result = result * 59 + ($escapedTags == null ? 43 : ((Object)$escapedTags).hashCode());
        Map<String, String> $badges = this.getBadges();
        result = result * 59 + ($badges == null ? 43 : ((Object)$badges).hashCode());
        Map<String, String> $badgeInfo = this.getBadgeInfo();
        result = result * 59 + ($badgeInfo == null ? 43 : ((Object)$badgeInfo).hashCode());
        Optional<String> $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : ((Object)$clientName).hashCode());
        String $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        Optional<String> $channelName = this.getChannelName();
        result = result * 59 + ($channelName == null ? 43 : ((Object)$channelName).hashCode());
        Optional<String> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Optional<String> $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        Set<CommandPermission> $clientPermissions = this.getClientPermissions();
        result = result * 59 + ($clientPermissions == null ? 43 : ((Object)$clientPermissions).hashCode());
        List<AutoModFlag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $rawMessage = this.getRawMessage();
        result = result * 59 + ($rawMessage == null ? 43 : $rawMessage.hashCode());
        Collection<String> $botOwnerIds = this.botOwnerIds;
        result = result * 59 + ($botOwnerIds == null ? 43 : ((Object)$botOwnerIds).hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AutoModFlag> getFlags() {
        Object value = this.flags.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.flags;
            synchronized (atomicReference) {
                value = this.flags.get();
                if (value == null) {
                    List<AutoModFlag> actualValue = FlagParser.parseFlags(this);
                    value = actualValue == null ? this.flags : actualValue;
                    this.flags.set(value);
                }
            }
        }
        return (List)(value == this.flags ? null : value);
    }
}

