/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.channel.CheerEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectCheerEvent
extends CheerEvent {
    private static final Map<String, Currency> CURRENCY_MAP;
    private static final float CREATOR_REVENUE_SPLIT = 0.8f;
    private final Integer amount;
    @NotNull
    private final String systemMessage;
    @Nullable
    private final AtomicReference<Object> currency = new AtomicReference();
    @Nullable
    private final AtomicReference<Object> monetaryValue = new AtomicReference();

    public DirectCheerEvent(IRCMessageEvent event) {
        this(event, event.getTagValue("msg-param-amount").map(Integer::parseInt).orElse(0), event.getTagValue("system-msg").map(String::trim).orElse(""));
    }

    DirectCheerEvent(IRCMessageEvent event, Integer amount, @NotNull String systemMessage) {
        super(event, event.getChannel(), event.getUser(), event.getMessage().orElse(""), Math.round((float)amount.intValue() * 0.8f), event.getSubscriberMonths().orElse(0), event.getSubscriptionTier().orElse(0), event.getFlags());
        this.amount = amount;
        this.systemMessage = systemMessage;
    }

    private static Currency parseCurrency(String systemMsg) {
        int end;
        int start = systemMsg.lastIndexOf(32);
        if (start < 0) {
            return null;
        }
        if (Character.isDigit(systemMsg.charAt(start + 1))) {
            start = systemMsg.substring(0, start).lastIndexOf(32);
        }
        for (end = ++start + 1; end < systemMsg.length() && !Character.isDigit(systemMsg.charAt(end)); ++end) {
        }
        return CURRENCY_MAP.get(systemMsg.substring(start, end).trim());
    }

    private static BigDecimal parseValue(String systemMsg) {
        int start = systemMsg.lastIndexOf(32);
        if (start < 0) {
            return null;
        }
        while (start < systemMsg.length() && !Character.isDigit(systemMsg.charAt(start))) {
            ++start;
        }
        int end = systemMsg.indexOf(32, start);
        if (end < 0) {
            end = systemMsg.length();
        }
        return new BigDecimal(systemMsg.substring(start, end));
    }

    public Integer getAmount() {
        return this.amount;
    }

    @NotNull
    public String getSystemMessage() {
        return this.systemMessage;
    }

    @Override
    public String toString() {
        return "DirectCheerEvent(amount=" + this.getAmount() + ", systemMessage=" + this.getSystemMessage() + ", currency=" + this.getCurrency() + ", monetaryValue=" + this.getMonetaryValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirectCheerEvent)) {
            return false;
        }
        DirectCheerEvent other = (DirectCheerEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$systemMessage = this.getSystemMessage();
        String other$systemMessage = other.getSystemMessage();
        if (this$systemMessage == null ? other$systemMessage != null : !this$systemMessage.equals(other$systemMessage)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$monetaryValue = this.getMonetaryValue();
        BigDecimal other$monetaryValue = other.getMonetaryValue();
        return !(this$monetaryValue == null ? other$monetaryValue != null : !((Object)this$monetaryValue).equals(other$monetaryValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DirectCheerEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $systemMessage = this.getSystemMessage();
        result = result * 59 + ($systemMessage == null ? 43 : $systemMessage.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $monetaryValue = this.getMonetaryValue();
        result = result * 59 + ($monetaryValue == null ? 43 : ((Object)$monetaryValue).hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Currency getCurrency() {
        Object value = this.currency.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.currency;
            synchronized (atomicReference) {
                value = this.currency.get();
                if (value == null) {
                    Currency actualValue = DirectCheerEvent.parseCurrency(this.getSystemMessage());
                    value = actualValue == null ? this.currency : actualValue;
                    this.currency.set(value);
                }
            }
        }
        return (Currency)(value == this.currency ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BigDecimal getMonetaryValue() {
        Object value = this.monetaryValue.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.monetaryValue;
            synchronized (atomicReference) {
                value = this.monetaryValue.get();
                if (value == null) {
                    BigDecimal actualValue = DirectCheerEvent.parseValue(this.getSystemMessage());
                    value = actualValue == null ? this.monetaryValue : actualValue;
                    this.monetaryValue.set(value);
                }
            }
        }
        return (BigDecimal)(value == this.monetaryValue ? null : value);
    }

    static {
        Set<Currency> currencies = Currency.getAvailableCurrencies();
        HashMap map = new HashMap(currencies.size() * 3);
        currencies.forEach(c -> map.put(c.getSymbol(), c));
        currencies.forEach(c -> map.putIfAbsent(c.getCurrencyCode(), c));
        currencies.forEach(c -> map.putIfAbsent(c.getDisplayName(), c));
        CURRENCY_MAP = Collections.unmodifiableMap(map);
    }
}

