/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.events4j.core.EventManager;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public interface ITwitchChat
extends AutoCloseable {
    public EventManager getEventManager();

    public void joinChannel(String var1);

    public boolean leaveChannel(String var1);

    default public boolean sendMessage(String channel, String message) {
        return this.sendMessage(channel, message, null);
    }

    default public boolean sendMessage(String channel, String message, String nonce, String replyMsgId) {
        LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
        if (nonce != null) {
            tags.put("client-nonce", nonce);
        }
        if (replyMsgId != null) {
            tags.put("reply-parent-msg-id", replyMsgId);
        }
        return this.sendMessage(channel, message, tags);
    }

    public boolean sendMessage(String var1, String var2, @Nullable Map<String, Object> var3);

    public Set<String> getChannels();

    @Override
    public void close();

    public long getLatency();

    public Map<String, String> getChannelIdToChannelName();

    public Map<String, String> getChannelNameToChannelId();

    default public boolean isChannelJoined(String channelName) {
        return this.getChannels().contains(channelName.toLowerCase());
    }

    default public boolean sendActionMessage(String channel, String message) {
        return this.sendMessage(channel, String.format("/me %s", message));
    }

    default public boolean setSlowMode(String channel, int seconds) {
        if (seconds <= 0) {
            return this.sendMessage(channel, "/slowoff");
        }
        if (seconds > 1800) {
            return false;
        }
        return this.sendMessage(channel, String.format("/slow %d", seconds));
    }

    default public boolean setFollowersOnly(String channel, Duration time) {
        if (time == null || time.isNegative()) {
            return this.sendMessage(channel, "/followersoff");
        }
        return this.sendMessage(channel, String.format("/followers %d", time.getSeconds()));
    }

    default public boolean setSubscribersOnly(String channel, boolean enable) {
        return this.sendMessage(channel, enable ? "/subscribers" : "/subscribersoff");
    }

    default public boolean setUniqueChat(String channel, boolean enable) {
        return this.sendMessage(channel, enable ? "/uniquechat" : "/uniquechatoff");
    }

    default public boolean setEmoteOnly(String channel, boolean enable) {
        return this.sendMessage(channel, enable ? "/emoteonly" : "/emoteonlyoff");
    }

    default public boolean clearChat(String channel) {
        return this.sendMessage(channel, "/clear");
    }

    default public boolean delete(String channel, String targetMsgId) {
        return this.sendMessage(channel, String.format("/delete %s", targetMsgId));
    }

    default public boolean timeout(String channel, String user, Duration duration, String reason) {
        StringBuilder sb = new StringBuilder(user).append(' ').append(duration.getSeconds());
        if (reason != null) {
            sb.append(' ').append(reason);
        }
        return this.sendMessage(channel, String.format("/timeout %s", sb.toString()));
    }

    default public boolean ban(String channel, String user, String reason) {
        StringBuilder sb = new StringBuilder(user);
        if (reason != null) {
            sb.append(' ').append(reason);
        }
        return this.sendMessage(channel, String.format("/ban %s", sb.toString()));
    }

    default public boolean unban(String channel, String user) {
        return this.sendMessage(channel, String.format("/unban %s", user));
    }

    default public boolean sendAnnouncement(String channel, String message) {
        return this.sendMessage(channel, String.format("/announce %s", message));
    }
}

