/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.chat.events.channel.FollowEvent;
import com.github.twitch4j.common.events.channel.ChannelChangeGameEvent;
import com.github.twitch4j.common.events.channel.ChannelChangeTitleEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.CollectionUtils;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.github.twitch4j.domain.ChannelCache;
import com.github.twitch4j.events.ChannelFollowCountUpdateEvent;
import com.github.twitch4j.events.ChannelGoLiveEvent;
import com.github.twitch4j.events.ChannelGoOfflineEvent;
import com.github.twitch4j.events.ChannelViewerCountUpdateEvent;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.domain.Follow;
import com.github.twitch4j.helix.domain.FollowList;
import com.github.twitch4j.helix.domain.Stream;
import com.github.twitch4j.helix.domain.StreamList;
import com.github.twitch4j.helix.domain.User;
import com.github.twitch4j.helix.domain.UserList;
import com.netflix.hystrix.HystrixCommand;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClientHelper
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TwitchClientHelper.class);
    public static final int REQUIRED_THREAD_COUNT = 2;
    private static final int MAX_LIMIT = 100;
    private final Set<String> listenForGoLive = ConcurrentHashMap.newKeySet();
    private final Set<String> listenForFollow = ConcurrentHashMap.newKeySet();
    private final TwitchHelix twitchHelix;
    private final EventManager eventManager;
    private final Consumer<List<String>> streamStatusEventTask;
    private final AtomicReference<Future<?>> streamStatusEventFuture = new AtomicReference();
    private final Function<String, Boolean> followerEventTask;
    private final AtomicReference<Future<?>> followerEventFuture = new AtomicReference();
    private final Cache<String, ChannelCache> channelInformation = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final ScheduledThreadPoolExecutor executor;
    private final AtomicReference<ExponentialBackoffStrategy> liveBackoff;
    private final AtomicReference<ExponentialBackoffStrategy> followBackoff;

    public TwitchClientHelper(TwitchHelix twitchHelix, EventManager eventManager, ScheduledThreadPoolExecutor executor) {
        this.twitchHelix = twitchHelix;
        this.eventManager = eventManager;
        this.executor = executor;
        ExponentialBackoffStrategy defaultBackoff = ExponentialBackoffStrategy.builder().immediateFirst(false).baseMillis(1000L).jitter(false).build();
        this.liveBackoff = new AtomicReference<ExponentialBackoffStrategy>(defaultBackoff);
        this.followBackoff = new AtomicReference<ExponentialBackoffStrategy>(defaultBackoff.copy());
        this.streamStatusEventTask = channels -> {
            HystrixCommand hystrixGetAllStreams = twitchHelix.getStreams(null, null, null, Integer.valueOf(channels.size()), null, null, channels, null);
            try {
                HashMap<String, Stream> streams = new HashMap<String, Stream>();
                channels.forEach(id -> streams.put((String)id, (Stream)null));
                ((StreamList)hystrixGetAllStreams.execute()).getStreams().forEach(s -> streams.put(s.getUserId(), (Stream)s));
                this.liveBackoff.get().reset();
                streams.forEach((userId, stream) -> {
                    if (!this.listenForGoLive.contains(userId)) {
                        return;
                    }
                    ChannelCache currentChannelCache = (ChannelCache)this.channelInformation.get(userId, s -> new ChannelCache());
                    if (stream != null && currentChannelCache.getUserName() == null) {
                        currentChannelCache.setUserName(stream.getUserName());
                    }
                    EventChannel channel = new EventChannel(userId, currentChannelCache.getUserName());
                    boolean dispatchGoLiveEvent = false;
                    boolean dispatchGoOfflineEvent = false;
                    boolean dispatchTitleChangedEvent = false;
                    boolean dispatchGameChangedEvent = false;
                    boolean dispatchViewersChangedEvent = false;
                    if (stream != null && stream.getType().equalsIgnoreCase("live")) {
                        boolean wasAlreadyLive;
                        if (currentChannelCache.getIsLive() != null && !currentChannelCache.getIsLive().booleanValue()) {
                            dispatchGoLiveEvent = true;
                        }
                        currentChannelCache.setIsLive(true);
                        boolean bl = wasAlreadyLive = !dispatchGoLiveEvent && currentChannelCache.getIsLive() == true;
                        if (wasAlreadyLive && currentChannelCache.getTitle() != null && !currentChannelCache.getTitle().equalsIgnoreCase(stream.getTitle())) {
                            dispatchTitleChangedEvent = true;
                        }
                        currentChannelCache.setTitle(stream.getTitle());
                        if (wasAlreadyLive && currentChannelCache.getGameId() != null && !currentChannelCache.getGameId().equals(stream.getGameId())) {
                            dispatchGameChangedEvent = true;
                        }
                        currentChannelCache.setGameId(stream.getGameId());
                        if (stream.getViewerCount() != null && !stream.getViewerCount().equals(currentChannelCache.getViewerCount().getAndSet(stream.getViewerCount())) && wasAlreadyLive) {
                            dispatchViewersChangedEvent = true;
                        }
                    } else {
                        if (currentChannelCache.getIsLive() != null && currentChannelCache.getIsLive().booleanValue()) {
                            dispatchGoOfflineEvent = true;
                        }
                        currentChannelCache.setIsLive(false);
                        currentChannelCache.setTitle(null);
                        currentChannelCache.setGameId(null);
                        currentChannelCache.getViewerCount().lazySet(null);
                    }
                    if (dispatchGoLiveEvent) {
                        com.github.twitch4j.common.events.channel.ChannelGoLiveEvent event = new com.github.twitch4j.common.events.channel.ChannelGoLiveEvent(channel, currentChannelCache.getTitle(), currentChannelCache.getGameId());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new ChannelGoLiveEvent(channel, (Stream)stream));
                    }
                    if (dispatchGoOfflineEvent) {
                        com.github.twitch4j.common.events.channel.ChannelGoOfflineEvent event = new com.github.twitch4j.common.events.channel.ChannelGoOfflineEvent(channel);
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new ChannelGoOfflineEvent(channel));
                    }
                    if (dispatchTitleChangedEvent) {
                        ChannelChangeTitleEvent event = new ChannelChangeTitleEvent(channel, currentChannelCache.getTitle());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new com.github.twitch4j.events.ChannelChangeTitleEvent(channel, (Stream)stream));
                    }
                    if (dispatchGameChangedEvent) {
                        ChannelChangeGameEvent event = new ChannelChangeGameEvent(channel, currentChannelCache.getGameId());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new com.github.twitch4j.events.ChannelChangeGameEvent(channel, (Stream)stream));
                    }
                    if (dispatchViewersChangedEvent) {
                        eventManager.publish((Object)new ChannelViewerCountUpdateEvent(channel, (Stream)stream));
                    }
                });
            }
            catch (Exception ex) {
                if (hystrixGetAllStreams != null && hystrixGetAllStreams.isFailedExecution()) {
                    log.trace(hystrixGetAllStreams.getFailedExecutionException().getMessage(), hystrixGetAllStreams.getFailedExecutionException());
                }
                log.error("Failed to check for Stream Events (Live/Offline/...): " + ex.getMessage());
            }
        };
        this.followerEventTask = channelId -> {
            HystrixCommand commandGetFollowers = twitchHelix.getFollowers(null, null, channelId, null, Integer.valueOf(100));
            try {
                ChannelCache currentChannelCache = (ChannelCache)this.channelInformation.get(channelId, s -> new ChannelCache());
                Instant lastFollowDate = currentChannelCache.getLastFollowCheck();
                boolean nextRequestCanBeImmediate = false;
                if (lastFollowDate != null) {
                    FollowList executionResult = (FollowList)commandGetFollowers.execute();
                    List followList = executionResult.getFollows();
                    this.followBackoff.get().reset();
                    String channelName = currentChannelCache.getUserName();
                    if (channelName == null && !followList.isEmpty()) {
                        channelName = ((Follow)followList.get(0)).getToName();
                        currentChannelCache.setUserName(channelName);
                    }
                    EventChannel channel = new EventChannel(channelId, channelName);
                    Integer followCount = executionResult.getTotal();
                    Integer oldTotal = currentChannelCache.getFollowers().getAndSet(followCount);
                    if (oldTotal != null && followCount != null && !followCount.equals(oldTotal)) {
                        eventManager.publish((Object)new ChannelFollowCountUpdateEvent(channel, followCount, oldTotal));
                    }
                    for (Follow follow : followList) {
                        if (lastFollowDate == null || follow.getFollowedAtInstant().isAfter(lastFollowDate)) {
                            lastFollowDate = follow.getFollowedAtInstant();
                        }
                        if (!follow.getFollowedAtInstant().isAfter(currentChannelCache.getLastFollowCheck())) continue;
                        FollowEvent event = new FollowEvent(channel, new EventUser(follow.getFromId(), follow.getFromName()));
                        eventManager.publish((Object)event);
                    }
                } else {
                    nextRequestCanBeImmediate = true;
                }
                if (currentChannelCache.getLastFollowCheck() == null) {
                    currentChannelCache.setLastFollowCheck(Instant.now());
                } else if (lastFollowDate != null) {
                    currentChannelCache.setLastFollowCheck(lastFollowDate);
                }
                return nextRequestCanBeImmediate;
            }
            catch (Exception ex) {
                if (commandGetFollowers != null && commandGetFollowers.isFailedExecution()) {
                    log.trace(ex.getMessage(), (Throwable)ex);
                }
                log.error("Failed to check for Follow Events: " + ex.getMessage());
                return false;
            }
        };
    }

    @Nullable
    public User enableStreamEventListener(String channelName) {
        UserList users = (UserList)this.twitchHelix.getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            User user = (User)users.getUsers().get(0);
            if (this.enableStreamEventListener(user.getId(), user.getLogin())) {
                return user;
            }
        } else {
            log.error("Failed to add channel {} to stream event listener!", (Object)channelName);
        }
        return null;
    }

    public Collection<User> enableStreamEventListener(Iterable<String> channelNames) {
        return CollectionUtils.chunked(channelNames, (int)100).stream().map(channels -> (UserList)this.twitchHelix.getUsers(null, null, channels).execute()).map(UserList::getUsers).filter(Objects::nonNull).flatMap(Collection::stream).filter(user -> this.enableStreamEventListener(user.getId(), user.getLogin())).collect(Collectors.toList());
    }

    public boolean enableStreamEventListener(String channelId, String channelName) {
        boolean add = this.listenForGoLive.add(channelId);
        if (!add) {
            log.info("Channel {} already added for Stream Events", (Object)channelName);
        } else {
            this.channelInformation.get((Object)channelId, s -> new ChannelCache(channelName));
        }
        this.startOrStopEventGenerationThread();
        return add;
    }

    public void disableStreamEventListener(String channelName) {
        UserList users = (UserList)this.twitchHelix.getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            users.getUsers().forEach(user -> this.disableStreamEventListenerForId(user.getId()));
        } else {
            log.error("Failed to remove channel " + channelName + " from stream event listener!");
        }
    }

    public void disableStreamEventListener(Iterable<String> channelNames) {
        CollectionUtils.chunked(channelNames, (int)100).forEach(channels -> {
            UserList users = (UserList)this.twitchHelix.getUsers(null, null, channels).execute();
            users.getUsers().forEach(user -> this.disableStreamEventListenerForId(user.getId()));
        });
    }

    public boolean disableStreamEventListenerForId(String channelId) {
        ChannelCache info;
        boolean remove = this.listenForGoLive.remove(channelId);
        if (!this.listenForFollow.contains(channelId)) {
            this.channelInformation.invalidate((Object)channelId);
        } else if (remove && (info = (ChannelCache)this.channelInformation.getIfPresent((Object)channelId)) != null) {
            info.setIsLive(null);
            info.setGameId(null);
            info.setTitle(null);
        }
        this.startOrStopEventGenerationThread();
        return remove;
    }

    @Nullable
    public User enableFollowEventListener(String channelName) {
        UserList users = (UserList)this.twitchHelix.getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            User user = (User)users.getUsers().get(0);
            if (this.enableFollowEventListener(user.getId(), user.getLogin())) {
                return user;
            }
        } else {
            log.error("Failed to add channel " + channelName + " to Follow Listener, maybe it doesn't exist!");
        }
        return null;
    }

    public Collection<User> enableFollowEventListener(Iterable<String> channelNames) {
        return CollectionUtils.chunked(channelNames, (int)100).stream().map(channels -> (UserList)this.twitchHelix.getUsers(null, null, channels).execute()).map(UserList::getUsers).filter(Objects::nonNull).flatMap(Collection::stream).filter(user -> this.enableFollowEventListener(user.getId(), user.getLogin())).collect(Collectors.toList());
    }

    public boolean enableFollowEventListener(String channelId, String channelName) {
        boolean add = this.listenForFollow.add(channelId);
        if (!add) {
            log.info("Channel {} already added for Follow Events", (Object)channelName);
        } else {
            this.channelInformation.get((Object)channelId, s -> new ChannelCache(channelName));
        }
        this.startOrStopEventGenerationThread();
        return add;
    }

    public void disableFollowEventListener(String channelName) {
        UserList users = (UserList)this.twitchHelix.getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            users.getUsers().forEach(user -> this.disableFollowEventListenerForId(user.getId()));
        } else {
            log.error("Failed to remove channel " + channelName + " from follow listener!");
        }
    }

    public void disableFollowEventListener(Iterable<String> channelNames) {
        CollectionUtils.chunked(channelNames, (int)100).forEach(channels -> {
            UserList users = (UserList)this.twitchHelix.getUsers(null, null, channels).execute();
            users.getUsers().forEach(user -> this.disableFollowEventListenerForId(user.getId()));
        });
    }

    public boolean disableFollowEventListenerForId(String channelId) {
        ChannelCache info;
        boolean remove = this.listenForFollow.remove(channelId);
        if (!this.listenForGoLive.contains(channelId)) {
            this.channelInformation.invalidate((Object)channelId);
        } else if (remove && (info = (ChannelCache)this.channelInformation.getIfPresent((Object)channelId)) != null) {
            info.setLastFollowCheck(null);
            info.getFollowers().set(null);
        }
        this.startOrStopEventGenerationThread();
        return remove;
    }

    private void startOrStopEventGenerationThread() {
        this.updateListener(this.listenForGoLive::isEmpty, this.streamStatusEventFuture, this::runRecursiveStreamStatusCheck, this.liveBackoff);
        this.updateListener(this.listenForFollow::isEmpty, this.followerEventFuture, this::runRecursiveFollowerCheck, this.followBackoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListener(BooleanSupplier stopCondition, AtomicReference<Future<?>> futureReference, Runnable startCommand, AtomicReference<ExponentialBackoffStrategy> backoff) {
        if (stopCondition.getAsBoolean()) {
            if (futureReference.get() != null) {
                Future future = null;
                AtomicReference<Future<?>> atomicReference = futureReference;
                synchronized (atomicReference) {
                    if (stopCondition.getAsBoolean()) {
                        future = futureReference.getAndSet(null);
                    }
                }
                if (future != null) {
                    future.cancel(false);
                    backoff.get().reset();
                }
            }
        } else if (futureReference.get() == null) {
            AtomicReference<Future<?>> atomicReference = futureReference;
            synchronized (atomicReference) {
                if (!stopCondition.getAsBoolean() && futureReference.get() == null) {
                    futureReference.set(this.executor.schedule(startCommand, backoff.get().get(), TimeUnit.MILLISECONDS));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRecursiveStreamStatusCheck() {
        if (this.streamStatusEventFuture.get() != null) {
            AtomicReference<Future<?>> atomicReference = this.streamStatusEventFuture;
            synchronized (atomicReference) {
                if (TwitchClientHelper.cancel(this.streamStatusEventFuture)) {
                    this.streamStatusEventFuture.set(this.executor.submit(new ListenerRunnable<List>(this.executor, CollectionUtils.chunked(this.listenForGoLive, (int)100), this.streamStatusEventFuture, this.liveBackoff, this::runRecursiveStreamStatusCheck, chunk -> {
                        this.streamStatusEventTask.accept((List<String>)chunk);
                        return false;
                    })));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRecursiveFollowerCheck() {
        if (this.followerEventFuture.get() != null) {
            AtomicReference<Future<?>> atomicReference = this.followerEventFuture;
            synchronized (atomicReference) {
                if (TwitchClientHelper.cancel(this.followerEventFuture)) {
                    this.followerEventFuture.set(this.executor.submit(new ListenerRunnable<String>(this.executor, new ArrayList<String>(this.listenForFollow), this.followerEventFuture, this.followBackoff, this::runRecursiveFollowerCheck, this.followerEventTask)));
                }
            }
        }
    }

    public void setThreadRate(long threadRate) {
        this.setThreadDelay(1000L / threadRate);
    }

    public void setThreadDelay(long threadDelay) {
        UnaryOperator updateBackoff = old -> {
            ExponentialBackoffStrategy next = old.toBuilder().baseMillis(threadDelay).build();
            next.setFailures(old.getFailures());
            return next;
        };
        this.liveBackoff.getAndUpdate(updateBackoff);
        this.followBackoff.getAndUpdate(updateBackoff);
    }

    public Optional<ChannelCache> getCachedInformation(String channelId) {
        return Optional.ofNullable((ChannelCache)this.channelInformation.getIfPresent((Object)channelId));
    }

    @Override
    public void close() {
        Future followerFuture;
        Future streamStatusFuture = this.streamStatusEventFuture.getAndSet(null);
        if (streamStatusFuture != null) {
            streamStatusFuture.cancel(false);
        }
        if ((followerFuture = (Future)this.followerEventFuture.getAndSet(null)) != null) {
            followerFuture.cancel(false);
        }
        this.listenForGoLive.clear();
        this.listenForFollow.clear();
        this.channelInformation.invalidateAll();
    }

    private static boolean cancel(AtomicReference<Future<?>> futureRef) {
        Future<?> future = futureRef.get();
        return future != null && future.cancel(false);
    }

    private static final class ListenerRunnable<T>
    implements Runnable {
        private final ScheduledExecutorService executor;
        private final List<T> channels;
        private final AtomicReference<Future<?>> futureReference;
        private final AtomicReference<ExponentialBackoffStrategy> backoff;
        private final Runnable startCommand;
        private final Function<T, Boolean> executeSingle;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.channels.isEmpty()) {
                if (this.futureReference.get() != null) {
                    AtomicReference<Future<?>> atomicReference = this.futureReference;
                    synchronized (atomicReference) {
                        if (TwitchClientHelper.cancel(this.futureReference)) {
                            this.backoff.get().reset();
                            this.futureReference.set(this.executor.schedule(this.startCommand, this.backoff.get().get(), TimeUnit.MILLISECONDS));
                        }
                    }
                }
            } else {
                this.run(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(int index) {
            Boolean skipDelay = this.executeSingle.apply(this.channels.get(index));
            if (this.futureReference.get() != null) {
                AtomicReference<Future<?>> atomicReference = this.futureReference;
                synchronized (atomicReference) {
                    if (TwitchClientHelper.cancel(this.futureReference)) {
                        this.futureReference.set(this.executor.schedule(index + 1 < this.channels.size() ? () -> this.run(index + 1) : this.startCommand, skipDelay != false ? 0L : this.backoff.get().get(), TimeUnit.MILLISECONDS));
                    }
                }
            }
        }

        public ListenerRunnable(ScheduledExecutorService executor, List<T> channels, AtomicReference<Future<?>> futureReference, AtomicReference<ExponentialBackoffStrategy> backoff, Runnable startCommand, Function<T, Boolean> executeSingle) {
            this.executor = executor;
            this.channels = channels;
            this.futureReference = futureReference;
            this.backoff = backoff;
            this.startCommand = startCommand;
            this.executeSingle = executeSingle;
        }

        public ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        public List<T> getChannels() {
            return this.channels;
        }

        public AtomicReference<Future<?>> getFutureReference() {
            return this.futureReference;
        }

        public AtomicReference<ExponentialBackoffStrategy> getBackoff() {
            return this.backoff;
        }

        public Runnable getStartCommand() {
            return this.startCommand;
        }

        public Function<T, Boolean> getExecuteSingle() {
            return this.executeSingle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListenerRunnable)) {
                return false;
            }
            ListenerRunnable other = (ListenerRunnable)o;
            ScheduledExecutorService this$executor = this.getExecutor();
            ScheduledExecutorService other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                return false;
            }
            List<T> this$channels = this.getChannels();
            List<T> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            AtomicReference<Future<?>> this$futureReference = this.getFutureReference();
            AtomicReference<Future<?>> other$futureReference = other.getFutureReference();
            if (this$futureReference == null ? other$futureReference != null : !this$futureReference.equals(other$futureReference)) {
                return false;
            }
            AtomicReference<ExponentialBackoffStrategy> this$backoff = this.getBackoff();
            AtomicReference<ExponentialBackoffStrategy> other$backoff = other.getBackoff();
            if (this$backoff == null ? other$backoff != null : !this$backoff.equals(other$backoff)) {
                return false;
            }
            Runnable this$startCommand = this.getStartCommand();
            Runnable other$startCommand = other.getStartCommand();
            if (this$startCommand == null ? other$startCommand != null : !this$startCommand.equals(other$startCommand)) {
                return false;
            }
            Function<T, Boolean> this$executeSingle = this.getExecuteSingle();
            Function<T, Boolean> other$executeSingle = other.getExecuteSingle();
            return !(this$executeSingle == null ? other$executeSingle != null : !this$executeSingle.equals(other$executeSingle));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduledExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            List<T> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            AtomicReference<Future<?>> $futureReference = this.getFutureReference();
            result = result * 59 + ($futureReference == null ? 43 : $futureReference.hashCode());
            AtomicReference<ExponentialBackoffStrategy> $backoff = this.getBackoff();
            result = result * 59 + ($backoff == null ? 43 : $backoff.hashCode());
            Runnable $startCommand = this.getStartCommand();
            result = result * 59 + ($startCommand == null ? 43 : $startCommand.hashCode());
            Function<T, Boolean> $executeSingle = this.getExecuteSingle();
            result = result * 59 + ($executeSingle == null ? 43 : $executeSingle.hashCode());
            return result;
        }

        public String toString() {
            return "TwitchClientHelper.ListenerRunnable(executor=" + this.getExecutor() + ", channels=" + this.getChannels() + ", futureReference=" + this.getFutureReference() + ", backoff=" + this.getBackoff() + ", startCommand=" + this.getStartCommand() + ", executeSingle=" + this.getExecuteSingle() + ")";
        }
    }
}

