/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.TwitchClientHelper;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.graphql.TwitchGraphQL;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.modules.ModuleLoader;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.tmi.TwitchMessagingInterface;

public interface ITwitchClient
extends AutoCloseable {
    public EventManager getEventManager();

    public TwitchExtensions getExtensions();

    public TwitchHelix getHelix();

    @Deprecated
    public TwitchKraken getKraken();

    public TwitchMessagingInterface getMessagingInterface();

    public ITwitchChat getChat();

    public ITwitchPubSub getPubSub();

    public TwitchGraphQL getGraphQL();

    public ModuleLoader getModuleLoader();

    public TwitchClientHelper getClientHelper();

    @Override
    default public void close() {
        TwitchClientHelper clientHelper;
        ITwitchChat chat = null;
        try {
            chat = this.getChat();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chat != null) {
            chat.close();
        }
        ITwitchPubSub pubsub = null;
        try {
            pubsub = this.getPubSub();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pubsub != null) {
            pubsub.close();
        }
        if ((clientHelper = this.getClientHelper()) != null) {
            clientHelper.close();
        }
    }
}

