/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.ITwitchClient;
import com.github.twitch4j.TwitchClientHelper;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.graphql.TwitchGraphQL;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.modules.ModuleLoader;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.tmi.TwitchMessagingInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClientPool
implements ITwitchClient {
    private static final Logger log = LoggerFactory.getLogger(TwitchClientPool.class);
    private final EventManager eventManager;
    private final TwitchExtensions extensions;
    private final TwitchHelix helix;
    private final TwitchKraken kraken;
    private final TwitchMessagingInterface messagingInterface;
    private final ITwitchChat chat;
    private final ITwitchPubSub pubsub;
    private final TwitchGraphQL graphql;
    private final ModuleLoader moduleLoader;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final TwitchClientHelper clientHelper;

    public TwitchClientPool(EventManager eventManager, TwitchExtensions extensions, TwitchHelix helix, TwitchKraken kraken, TwitchMessagingInterface messagingInterface, ITwitchChat chat, ITwitchPubSub pubsub, TwitchGraphQL graphql, ScheduledThreadPoolExecutor threadPoolExecutor) {
        this.eventManager = eventManager;
        this.extensions = extensions;
        this.helix = helix;
        this.kraken = kraken;
        this.messagingInterface = messagingInterface;
        this.chat = chat;
        this.pubsub = pubsub;
        this.graphql = graphql;
        this.clientHelper = new TwitchClientHelper(helix, eventManager, threadPoolExecutor);
        this.scheduledThreadPoolExecutor = threadPoolExecutor;
        this.moduleLoader = new ModuleLoader(this);
        this.eventManager.getServiceMediator().addService("twitch4j", (Object)this);
    }

    @Override
    public TwitchExtensions getExtensions() {
        if (this.extensions == null) {
            throw new RuntimeException("You have not enabled the Extensions Module! Please check out the documentation on Twitch4J -> Extensions.");
        }
        return this.extensions;
    }

    @Override
    public TwitchHelix getHelix() {
        if (this.helix == null) {
            throw new RuntimeException("You have not enabled the Helix Module! Please check out the documentation on Twitch4J -> Helix.");
        }
        return this.helix;
    }

    @Override
    @Deprecated
    public TwitchKraken getKraken() {
        if (this.kraken == null) {
            throw new RuntimeException("You have not enabled the Kraken Module! Please check out the documentation on Twitch4J -> Kraken.");
        }
        return this.kraken;
    }

    @Override
    public TwitchMessagingInterface getMessagingInterface() {
        if (this.messagingInterface == null) {
            throw new RuntimeException("You have not enabled the Twitch Messaging Interface Module! Please check out the documentation on Twitch4J -> TMI.");
        }
        return this.messagingInterface;
    }

    @Override
    public ITwitchChat getChat() {
        if (this.chat == null) {
            throw new RuntimeException("You have not enabled the Chat Module! Please check out the documentation on Twitch4J -> Chat.");
        }
        return this.chat;
    }

    @Override
    public ITwitchPubSub getPubSub() {
        if (this.pubsub == null) {
            throw new RuntimeException("You have not enabled the PubSub Module! Please check out the documentation on Twitch4J -> PubSub.");
        }
        return this.pubsub;
    }

    @Override
    public TwitchGraphQL getGraphQL() {
        if (this.graphql == null) {
            throw new RuntimeException("You have not enabled the GraphQL Module! Please check out the documentation on Twitch4J -> GraphQL.");
        }
        return this.graphql;
    }

    @Override
    public void close() {
        BasicThreadFactory threadFactory;
        log.info("Closing TwitchClientPool ...");
        ITwitchClient.super.close();
        if (this.scheduledThreadPoolExecutor.getThreadFactory() instanceof BasicThreadFactory && (threadFactory = (BasicThreadFactory)this.scheduledThreadPoolExecutor.getThreadFactory()).getNamingPattern().equalsIgnoreCase("twitch4j-%d")) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    @Override
    public TwitchClientHelper getClientHelper() {
        return this.clientHelper;
    }
}

